unit ContactsManager;

interface


(******
 *
 * Original code is from http://www.fmxexpress.com/access-android-contacts-manager-with-firemonkey-in-delphi-xe5/
 * and from http://www.fmxexpress.com/access-ios-contacts-with-firemonkey-in-delphi-xe5/
 *
 * Compiled to one library by P.J.Strnad
 *
 * http://pjstrnad.com
 *
 *
 *
 * USAGE:
 *   1) call function createContactsManager from your code. It will return TContactsManager class. At windows nil is returned. 
 *    Never use TContactsManager.create as it's an abstract class.
 *
 *   2) From created object call function ExtractContactsList
 *   
 *   3) Property ContactsCount will return number of contacts and each contact can be accessed via property Contacts[index].
 *
 *   4) You can limit number of loaded items by setting limitTo
 *         
 ******)

uses
  System.Classes;

Type
  // Record for contact data
  TContactData = Record
    LastName   : String;
    FirstName   : String;
    Email : String;
    Phone : string;
    {$IF DEFINED(ANDROID)}
    LookupID : string;
    Display_Name : String;  // Display name : in almost smartphone it's last name + space + First name
    {$ENDIF}
  End;
  PContactData = ^TContactData;   // Pointer to record

  // This class manage contact data
  TContactsManager = class abstract
  protected
    fContactsList : TList;           // List of contacts
    procedure ClearList;  // procedure to clear contacts list
    function GetContactsCount : integer;   // Retrieveing contacts number
    function GetContact(AIndex : Integer) : PContactData; //Access a contact record
  public
    limitTo:integer;

    constructor Create;
    Destructor Destroy; override;

    procedure ExtractContactsList; virtual; abstract;         //Retrieve all contacts

    property ContactsCount : Integer read GetContactsCount;
    property Contacts[AIndex : Integer] : PContactData read GetContact; default;
  end;

function createContactsManager:TContactsManager;

implementation
uses
 {$IF DEFINED(ANDROID)}
 ContactsManager.Android,
 {$ELSEIF DEFINED(iOS)}
 ContactsManager.iOS,
 {$ENDIF}
 System.SysUtils;

function createContactsManager:TContactsManager;
begin
 {$IF DEFINED(ANDROID)}
 result:=TContactsManagerAndroid.Create;
 {$ELSEIF DEFINED(iOS)}
 result:=TContactsManageriOS.Create;
 {$ELSE}
 result:=nil;
 {$ENDIF}
end;

{ TContactsManager }

procedure TContactsManager.ClearList;
var
 i : integer;

begin
  try
    for i := fContactsList.Count -1 downto 0 do
    begin
      Dispose(PContactData(fContactsList[i]));
      fContactsList.Delete(i);
    end;
    fContactsList.Clear;
  except
    On E:Exception do
      Raise Exception.create('[TiOSContactsManager.ClearList] : '+E.message);
  end;
end;

constructor TContactsManager.Create;
begin
  fContactsList := TList.Create;  // Create contact ilst object
  limitTo:=-1;
end;

destructor TContactsManager.Destroy;
begin
  ClearList;
  fcontactsList.Free;
  inherited;
end;

function TContactsManager.GetContact(AIndex: Integer): PContactData;
begin
  try
    if AIndex > fContactsList.Count -1 then
      raise Exception.Create('Index out of bounds');
    Result := fContactsList[AIndex]                // return contact data from index
  except
    On E:Exception do
      Raise Exception.create('[TContactManager.GetContact] : '+E.message);
  end;
end;


function TContactsManager.GetContactsCount: integer;
begin
  Result := fContactsList.Count;
end;

end.

