unit ContactsManager.Android;

interface

(******
 *
 * Original code is from http://www.fmxexpress.com/access-android-contacts-manager-with-firemonkey-in-delphi-xe5/
 *
 * Compiled to one library by P.J.Strnad
 *
 * http://pjstrnad.com
 *
 ******)

{$IF DEFINED(ANDROID)}
uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  ContactsManager,
  FMX.Helpers.Android,Androidapi.JNI.provider, Androidapi.JNI.JavaTypes,
  Androidapi.JNI.GraphicsContentViewText, Androidapi.JNI.Net, Androidapi.Jni.App,
  Androidapi.JNIBridge, Androidapi.Helpers;

Type
  // This class manage contact data
  TContactsManagerAndroid = class(TContactsManager)
   procedure GetContactExtendedData(AContact : PContactData);
  public
   procedure ExtractContactsList; override;         //Retrieve all contacts
  end;

{$ENDIF}
implementation

{$IF DEFINED(ANDROID)}

{ TContactsManagerAndroid }

{-------------------------------------------------------------------------------
  Procedure: TContactsManagerAndroid.ExtractContactsList : Retrieve all contacts
  DateTime:  2014.01.02
  Arguments: None
  Result:    None
-------------------------------------------------------------------------------}
procedure TContactsManagerAndroid.ExtractContactsList;
var
  wUri : JNet_URI;
  wCursor : JCursor;
  wLookup_Idx : Integer;
  wDisplayNameIdx : integer;
  wContact : PContactData;
begin
  try
    ClearList;
    wUri :=  TJContactsContract_Contacts.JavaClass.CONTENT_URI;   // Contact  URI
    with  SharedActivityContext.getContentResolver do
      wCursor :=query(wUri,nil, nil,nil, StringToJString('display_name ASC')); // Query to get all contact sorted by displayname
    try
      wLookup_Idx := wCursor.getColumnIndex(StringToJString('lookup')); //Getting id column index
      wDisplayNameIdx := wCursor.getColumnIndex(StringToJString('display_name'));  // getting displayname column index
      while (wCursor.moveToNext) do  // for each row
      begin
        New(wContact);      // Create a new contact record
        wContact.LookupID      := JStringToString(wCursor.getString(wLookup_Idx));    // Set contact ID
        wContact.Display_Name  := JStringToString(wCursor.getString(wDisplayNameIdx));  //Set contact displayname
        GetContactExtendedData(wContact);   // Extract extended data (to get first name, last name, Email, Phone..)
        fContactsList.Add(wContact);        // Add contact to list
      end;
    finally
      wCursor.close;    // Close table cursor
      wCursor := nil;
    end;
  except
    On E:Exception do
      Raise Exception.create('[GetContactsList] : '+E.message);
  end;

end;


{-------------------------------------------------------------------------------
  Procedure: TContactsManagerAndroid.GetContactExtendedData  : get additional data for a contact
  DateTime:  2014.01.02
  Arguments: AContact : PContactData
  Result:    None
-------------------------------------------------------------------------------}
procedure TContactsManagerAndroid.GetContactExtendedData(AContact : PContactData);
var
  wSubCursor : JCursor;
  wfilter : TJavaObjectArray<JString>;
  wJQueryParams : TJavaObjectArray<JString>;
  wDataUri : JNet_URI;
begin
  try
    // Filter to extract only familyname, first name1 and first name 2 (http://developer.android.com/reference/android/provider/ContactsContract.DataColumns.html)
    wfilter := TJavaObjectArray<JString>.Create(3);
    wfilter[0] := TJCommonDataKinds_StructuredName.JavaClass.FAMILY_NAME;
    wfilter[1] := TJCommonDataKinds_StructuredName.JavaClass.GIVEN_NAME;
    wfilter[2] := TJCommonDataKinds_StructuredName.JavaClass.MIDDLE_NAME;

    // Qurey condition (Exrtact only data for specific ID)
    wJQueryParams := TJavaObjectArray<JString>.Create(2);
    wJQueryParams[0] := TJCommonDataKinds_StructuredName.JavaClass.CONTENT_ITEM_TYPE;
    wJQueryParams[1] := StringToJString(AContact.LookupID);

    wDataUri := TJContactsContract_Data.JavaClass.CONTENT_URI;  // Contacts data uri

    with SharedActivity.getContentResolver do
      wSubCursor := Query(wDataUri,wfilter,StringToJString('mimetype = ? AND lookup = ?') , wJQueryParams,nil); // Exec query
    Try
      if wSubCursor.getCount > 0 then // if query return some data
      begin
        // Getting only first row, as we retrieving only names, a contact can have only one first name, one familyname,
        // for phone number for example, we need to loop on each row (while (wSubCursor.moveToNext) do) because a contact can have many phone number
        wSubCursor.moveToNext;
        AContact.LastName := JStringToString(wSubCursor.getString(0));
        AContact.FirstName := JStringToString(wSubCursor.getString(1)) + ' ' + JStringToString(wSubCursor.getString(2));
      end;
    Finally
      wSubCursor.close;
      wSubCursor := nil;
    End;

    // ------------- EMAIL -----------------------------
    // Filter to extract Email only
    wfilter := TJavaObjectArray<JString>.Create(1);
    wfilter[0] := TJCommonDataKinds_Email.JavaClass.ADDRESS;

    // Qurey condition (Exrtact only data for specific ID)
    wJQueryParams := TJavaObjectArray<JString>.Create(2);
    wJQueryParams[0] := TJCommonDataKinds_Email.JavaClass.CONTENT_ITEM_TYPE;
    wJQueryParams[1] := StringToJString(AContact.LookupID);

    wDataUri := TJContactsContract_Data.JavaClass.CONTENT_URI;  // Contacts data uri
    with SharedActivity.getContentResolver do
      wSubCursor := Query(wDataUri,wfilter,StringToJString('mimetype = ? AND lookup = ?') , wJQueryParams,nil); // Exec query
    Try
      if wSubCursor.getCount > 0 then // if query return some data
      begin
        // Getting only first email , a contact can have many emails, so if needed,
        // we need to loop on each row (while (wSubCursor.moveToNext) do)
        wSubCursor.moveToNext;
        AContact.Email := JStringToString(wSubCursor.getString(0));
      end;
    Finally
      wSubCursor.close;
      wSubCursor := nil;
    End;

    // ------------- PHONE -----------------------------
    // Filter to extract Email only
    wfilter := TJavaObjectArray<JString>.Create(1);
    wfilter[0] := TJCommonDataKinds_Phone.JavaClass.NUMBER;

    // Qurey condition (Exrtact only data for specific ID)
    wJQueryParams := TJavaObjectArray<JString>.Create(2);
    wJQueryParams[0] := TJCommonDataKinds_Phone.JavaClass.CONTENT_ITEM_TYPE;
    wJQueryParams[1] := StringToJString(AContact.LookupID);

    wDataUri := TJContactsContract_Data.JavaClass.CONTENT_URI;  // Contacts data uri
    with SharedActivity.getContentResolver do
      wSubCursor := Query(wDataUri,wfilter,StringToJString('mimetype = ? AND lookup = ?') , wJQueryParams,nil); // Exec query
    Try
      if wSubCursor.getCount > 0 then // if query return some data
      begin
        // Getting only first phone number , a contact can have multiple phone numbers, so if needed,
        // we need to loop on each row (while (wSubCursor.moveToNext) do)
        wSubCursor.moveToNext;
        AContact.Phone := JStringToString(wSubCursor.getString(0));
      end;
    Finally
      wSubCursor.close;
      wSubCursor := nil;
    End;
  except
    On E:Exception do
      Raise Exception.create('[TContactsManagerAndroid.GetContactExtendedData] : '+E.message);
  end;
end;



{$ENDIF}
end.

