unit ContactsManager.iOS;

interface

{$IFDEF IOS}

(******
 *
 * Original code is from http://www.fmxexpress.com/access-ios-contacts-with-firemonkey-in-delphi-xe5/
 *
 * Access to Contacts was taken from http://sourceforge.net/projects/dpfdelphiios/
 *
 * Compiled to one library by P.J.Strnad
 *
 * http://pjstrnad.com
 *
 ******)
uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  ContactsManager,

  FMX.Dialogs,

  iOSapi.UIKit, Macapi.ObjectiveC, iOSapi.CocoaTypes, iOSapi.CoreGraphics,
  iOSapi.Foundation, iOSapi.CoreLocation, Macapi.CoreFoundation,
  iOSAddressBookWrap;

Type

  TContactsManageriOS = class(TContactsManager)
  protected
//   AddressBook: TDPFAddressBook;
   procedure AddressBookRequestAccess(Sender: TObject; const Granted: Boolean);
   procedure ExtractContactsInternal;       // Extract all contacts
   procedure RequestAccess;
  public
//   constructor create;
   procedure ExtractContactsList; override;       // Extract all contacts
  end;

type
{$M+}
  ABAddressBookRef            = CFTypeRef;

  TABAddressBookRequestAccessCompletionHandler = procedure( grant: Pointer; error: PCFErrorRef );

const
  libAddressBook   = '/System/Library/Frameworks/AddressBook.framework/AddressBook';

  kABAuthorizationStatusNotDetermined = 0; // iOS 6 and later
  kABAuthorizationStatusRestricted    = 1; // iOS 6 and later
  kABAuthorizationStatusDenied        = 2; // iOS 6 and later
  kABAuthorizationStatusAuthorized    = 3; // iOS 6 and later

function ABAddressBookGetAuthorizationStatus: ABAuthorizationStatus; cdecl; external libAddressBook name _PU + 'ABAddressBookGetAuthorizationStatus'; // iOS 6 and later
function ABAddressBookCreateWithOptions( options: CFDictionaryRef; error: CFErrorRef ): ABAddressBookRef; cdecl; external libAddressBook name _PU + 'ABAddressBookCreateWithOptions';
procedure ABAddressBookRequestAccessWithCompletion( addressBook: ABAddressBookRef; completion: TABAddressBookRequestAccessCompletionHandler ); cdecl; external libAddressBook name _PU + 'ABAddressBookRequestAccessWithCompletion'; // iOS 6 and later

{$ENDIF}

implementation

{$IFDEF IOS}
{ TContactsManageriOS }


{-------------------------------------------------------------------------------
  Procedure: NSStrToStr   : Convert iOS string to delphi String;
  DateTime:  2014.01.03
  Arguments: const ASource: NSString
  Result:    string
-------------------------------------------------------------------------------}
function NSStrToStr( const ASource: NSString ): string;
begin
  Result := UTF8ToString( ASource.UTF8String );
end;


{-------------------------------------------------------------------------------
  Procedure: CFToDelphiString : Convert CFString to delphi string
  DateTime:  2014.01.03
  Arguments: const ACFStr: CFStringRef
  Result:    string
-------------------------------------------------------------------------------}
function CFToDelphiString(const ACFStr: CFStringRef): string;
var
  wRange: CFRange;
begin
  Result := '';
  if ACFStr <> nil then    //if contact peoperty is null, return nil string (for debug)
  begin
    wRange.location := 0;
    wRange.length := CFStringGetLength(ACFStr);
    SetLength(Result, wRange.length);
    if wRange.length = 0 then Exit;
    CFStringGetCharacters(ACFStr, wRange, PWideChar(Result));
  end;
end;


{  TContactsManageriOS  }


//procedure TContactsManageriOS.ExtractContactsInternal;
//begin
// inherited create;
//
// AddressBook := TDPFAddressBook.Create(Self);
// AddressBook.OnRequestAccess := AddressBookRequestAccess;
//end;

procedure TContactsManageriOS.ExtractContactsList;
begin
 RequestAccess;
end;

procedure TContactsManageriOS.RequestAccess;
var
  AddressBook: ABAddressBookRef;
  AStatus    : ABAuthorizationStatus;
  // grant                : Boolean;
  isClicked            : Boolean;
  FNSDefaultRunLoopMode: NSString;

begin
  if TOSVersion.Major >= 6.0 then
  begin
    AStatus := ABAddressBookGetAuthorizationStatus( );
    if AStatus = kABAuthorizationStatusNotDetermined then
    begin
      AddressBook := ABAddressBookCreateWithOptions( nil, nil );
      ABAddressBookRequestAccessWithCompletion( AddressBook, nil );

      FNSDefaultRunLoopMode := NSDefaultRunLoopMode;
      isClicked             := false;
      while not isClicked do
      begin
        TNSRunLoop.Wrap( TNSRunLoop.OCClass.currentRunLoop ).runMode( FNSDefaultRunLoopMode, TNSDate.Wrap( TNSDate.OCClass.dateWithTimeIntervalSinceNow( 0.1 ) ) );
        AStatus   := ABAddressBookGetAuthorizationStatus( );
        isClicked := AStatus <> kABAuthorizationStatusNotDetermined;
      end;

      if AddressBook <> nil then
        CFRelease( AddressBook );
      RequestAccess;
    end
    else
    begin
     AddressBookRequestAccess(self, true);
//      if Assigned( FOnRequestAccess ) then
//        FOnRequestAccess( self, true )
    end;
  end
  else
  begin
   AddressBookRequestAccess(self, true);
//    if Assigned( FOnRequestAccess ) then
//      FOnRequestAccess( self, true )
  end;
end;

  {-------------------------------------------------------------------------------
  Procedure: TContactsManageriOS.ExtractContacts
  Author:    ehkhalid
  DateTime:  2014.01.03
  Arguments: None
  Result:    None
-------------------------------------------------------------------------------}
procedure TContactsManageriOS.ExtractContactsInternal;
 var
   wAddressBook : ABAddressBookRef;     // AddressBook reference
   wContactsList : CFArrayRef;          // contacts list array
   wcontactsCount : CFIndex;            //Contacts count
   wIosContactRef : ABRecordRef;        // Contact Reference
   wCFFirstName : CFStringRef;
   wCFLastName : CFStringRef;
   wCFEmailList : ABMultiValueRef;      //Emails List
   wCFEmail : CFStringRef;              //Email value (label and value)
   wEmailLabel : string;
   wStrEmail : string;                  // Concatened emails value as string
   wCFEPhoneList : CFStringRef;         //Phone numbers List
   wCFPhone : CFStringRef;              // Phone value and label
   wPhoneLabel : String;
   wStrPhone : string;                  //Phone value as string
   i,j : CFIndex;
   wNewContact : PContactData;           // Contact record
begin
  ClearList;

  wAddressBook := ABAddressBookCreate;        // create Addressebook interface
  try
    wContactsList := ABAddressBookCopyArrayOfAllPeople(wAddressBook);  // Retrieve all contacts
    wcontactsCount := ABAddressBookGetPersonCount(wAddressBook);       // get contacts count
    for i := 0 to wcontactsCount -1 do                                 // for each contact
    begin
      wIosContactRef := CFArrayGetValueAtIndex( wContactsList , i );    // get contact pointer

      New(wNewContact);
      wCFFirstName := ABRecordCopyValue(wIosContactRef,kABPersonFirstNameProperty);   // create a new contact record
      wNewContact.FirstName := CFToDelphiString(wCFFirstName);  // Extract first name
      wCFLastName := ABRecordCopyValue(wIosContactRef,kABPersonLastNameProperty);
      wNewContact.LastName := CFToDelphiString(wCFLastName);    // Extract last name

      // Emails
      wCFEmailList := ABRecordCopyValue(wIosContactRef, kABPersonEmailProperty);  //Extract emails list
      wStrEmail := '';
      for j := 0 to ABMultiValueGetCount(wCFEmailList) -1 do                      // for each email
      begin
        wEmailLabel := CFToDelphiString(ABMultiValueCopyLabelAtIndex(wCFEmailList, j));   // Get email label
        wCFEmail :=  ABMultiValueCopyValueAtIndex(wCFEmailList, j);
        if wCFEmail <> nil then
        begin
          if CompareText(wEmailLabel,kABPersonHomeEmailLabel) = 0 then           // return value only if email label is "Home"
            wStrEmail := CFToDelphiString(wCFEmail);
          CFRelease(wCFEmail);
          if Trim(wStrEmail) <> '' then
          begin
            wNewContact.Email := wStrEmail;
            Break;
          end;
        end;                                       // Release memory
      end;
      wNewContact.Email := wStrEmail;
      if wCFEmailList <> nil then                        // Release memory
        CFRelease(wCFEmailList);

      //Phones
      wCFEPhoneList := ABRecordCopyValue(wIosContactRef, kABPersonPhoneProperty);  //The same as email
      wStrPhone := '';
      for j := 0 to ABMultiValueGetCount(wCFEPhoneList) -1 do
      begin
        wPhoneLabel := CFToDelphiString(ABMultiValueCopyLabelAtIndex(wCFEPhoneList, j));  // get pone label
        wCFPhone :=  ABMultiValueCopyValueAtIndex(wCFEPhoneList, j);
        if wCFPhone <> nil then
        begin
          if CompareText(wPhoneLabel,kABPersonPhoneMobileLabel) = 0 then               // return value only if mobile number
            wStrPhone := CFToDelphiString(wCFPhone)
          else if CompareText(wPhoneLabel,kABPersonPhoneIPhoneLabel) = 0 then          // or Iphone number
            wStrPhone := CFToDelphiString(wCFPhone);
          CFRelease(wCFPhone);
          if Trim(wStrPhone) <> '' then
          begin
            wNewContact.Phone := wStrPhone;
            Break;
          end;
        end;
      end;

      if wCFEPhoneList <> nil then                            // Release memory
        CFRelease(wCFEPhoneList);

      fcontactsList.Add(wNewContact);   // Add contact to list
    end;
  finally
    wAddressBook := nil;
  end;
end;


procedure TContactsManageriOS.AddressBookRequestAccess(Sender: TObject; const Granted: Boolean);
begin
 if (Granted=True) then
  ExtractContactsInternal
 else
  ShowMessage('Go to Setting->Privacy->Contacts and switch on this application');
end;

{$ENDIF}

end.
