unit HS_FMXHints;

// (c) copyright Harry Stahl Software, www.hastasoft.de or  www.devpage.de
// Usable for DXE2 to DXE5, for newer Versions test it by your self
// You can use this software free, but use it on your own risk
// 04.04.2013

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Effects,  FMX.Controls, FMX.Forms,
  {$IF FireMonkeyVersion > 17.0} FMX.StdCtrls, {$IFEND}
  FMX.Objects;

type
  {$IF FireMonkeyVersion > 17.0} // XE4 oder neuer
  TButton = class (FMX.StdCtrls.TButton);
  TSpeedButton = class (FMX.StdCtrls.TSpeedButton);
  TLabel = class (FMX.StdCtrls.TLabel);
  {$ELSE} // XE2 oder XE3
  TButton = class (FMX.Controls.TButton);
  TSpeedButton = class (FMX.Controls.TSpeedButton);
  TLabel = class (FMX.Controls.TLabel);
  {$IFEND}

  procedure HintEnter (Self, Sender: TObject);
  procedure HintExit (Self, Sender: TObject);
  procedure HintTimer (Self, Sender: TObject);

  procedure SetHintSetting (TimeBeforeShow, TimeToShow: Integer; DynamicShow: Boolean; TC: TAlphaColor);
  procedure SetAHint (ic: TObject; txt: string);

implementation

var
  ACallHint: TCalloutRectangle;
  Lab, lbDummy: TLabel; TT: TTimer; DynamicTime: Boolean;
  TimeBefore, TimeShow: Integer;
  EventEnter, EventExit, EventTimer: TNotifyEvent;

procedure SetHintSetting (TimeBeforeShow, TimeToShow: Integer; DynamicShow: Boolean; TC: TAlphaColor);
begin
  TimeBefore := TimeBeforeShow;
  TimeShow := TimeToShow;
  DyNamicTime := DyNamicShow;
  ACallHint.Fill.Color := TC;
end;

procedure HintTimer (Self, Sender: TObject);
begin
  TT.Enabled := false;

  if ACallHint.Visible = false then begin
    ACallHint.Visible := True;
    ACallHint.BringToFront;
    TT.Enabled := True;

    if DynamicTime then begin
      TT.Interval := TimeShow + 45 * (Length (lab.Text));
    end else begin
      TT.Interval := TimeShow;
    end;

  end else begin
    ACallHint.Visible := false;
    ACallHint.Parent := NIL;
  end;
end;

procedure InitHintSetting;
var
  ShadowEffect1: TShadowEffect;
begin
  TMethod (EventEnter).code := @HintEnter;
  TMethod (EventExit).code := @HintExit;
  TMethod (EventTimer).code := @HintTimer;
  //TMethod (Event2).data := NIL; // Not needed here

  ACallHint:= TCalloutRectangle.Create(NIL);
  ACallHint.Width := 200; ACallHint.Height := 35;
  ACallHint.CalloutOffset := 8;
  ACallHint.Fill.Color := TAlphaColorRec.Beige;

  {$IF FireMonkeyVersion <= 17.0} //XE3-XE3
  lbDummy := TLabel.Create (ACallHint); lbDummy.Parent := ACallHint; lbDummy.Align := TAlignLayout.alTop; lbDummy.Height := 10;
  {$IFEND}

  ShadowEffect1:= TShadowEffect.Create(ACallHint);
  ShadowEffect1.Parent := ACallHint;

  Lab := TLabel.Create (ACallHint);
  Lab.Parent := ACallHint;
  Lab.Align := TAlignLayout.alClient;
  Lab.TextAlign := TTextAlign.taCenter;
  Lab.VertTextAlign := TTextAlign.taCenter;
  with Lab.Margins do begin Top := 10; left := 5; right := 5; end;

  TimeBefore := 800; TimeShow := 2000; // Standard-Init-Settings

  TT := TTImer.Create(NIL);
  TT.Interval := TimeBefore;
  TT.Ontimer := EventTimer;
end;

procedure SetAHint (ic: TObject; txt: string);
begin
  if ic is TButton then begin
    TButton (ic).Hint := txt;
    if not Assigned (TButton (ic).OnMouseEnter) then TButton (ic).OnMouseEnter := EventEnter;
    if not Assigned (TButton (ic).OnMouseLeave) then TButton (ic).OnMouseLeave := EventExit
  end;

  if ic is TSpeedbutton then begin
    TSpeedButton (ic).Hint := txt;
    if not Assigned (TSpeedButton (ic).OnMouseEnter) then TSpeedButton (ic).OnMouseEnter := EventEnter;
    if not Assigned (TSpeedButton (ic).OnMouseLeave) then TSpeedButton (ic).OnMouseLeave := EventExit
  end;

  if ic is TLabel then begin
    TLabel (ic).Hint := txt;
    if not Assigned (TLabel (ic).OnMouseEnter) then TLabel (ic).OnMouseEnter := EventEnter;
    if not Assigned (TLabel (ic).OnMouseLeave) then TLabel (ic).OnMouseLeave := EventExit;
  end;
end;

procedure HintEnter(Self, Sender: TObject);
var
  aw: Extended; aTop:Extended; tp: TPointF; DForm: TForm;

  function GetFormParent (o: TFMXObject): TFMXObject;
  var
    L: Integer;
  begin
    Result := o;
    while Result.Parent <> NIL do begin
      Result := Result.Parent;
      if Result is TForm then break;
    end;

    DForm := TForm(Result);
  end;

begin
  ACallhint.Parent := GetFormParent (TControl (sender).Parent);

  if Sender is TButton then begin
    Lab.text := TButton (sender).hint;
    TP := TButton (sender).LocalToScreen(PointF (TButton (sender).position.X, TButton (sender).Position.Y));
    TP := DForm.ScreenToClient(tp);
    ACallHint.position.X := Tp.X-TButton (sender).Position.x;
    ACallHint.Position.Y := TP.Y + TButton (sender).Height+2 - TButton (sender).Position.Y;
    ATop := ACAllHint.Position.Y - TButton (sender).height - 2;
  end;

  if Sender is TSpeedButton then begin
    Lab.text := TSpeedButton (sender).hint;
    TP := TSpeedButton (sender).LocalToScreen(PointF (TSpeedButton (sender).position.X, TSpeedButton (sender).Position.Y));
    TP := DForm.ScreenToClient(tp);
    ACallHint.position.X := Tp.X-TSpeedButton (sender).Position.x;
    ACallHint.Position.Y := TP.Y + TSpeedButton (sender).Height+2 - TSpeedButton (sender).Position.Y;
    ATop := ACAllHint.Position.Y - TSpeedButton (sender).height - 2;
  end;

  if Sender is TLabel then begin
    // Label.hittest must be set to True in Objectinspector
    Lab.text := TLabel (sender).hint;
    TP := TLabel (sender).LocalToScreen(PointF (TLabel (sender).position.X, TLabel (sender).Position.Y));
    TP := DForm.ScreenToClient(tp);
    ACallHint.position.X := TP.X- TLabel (sender).position.X;
    ACallHint.Position.Y := Tp.y - TLabel (sender).Position.Y + TLabel (sender).Height+2;
    ATop := ACAllHint.Position.Y - TLabel (sender).height - 2;
  end;

  aw := lab.Canvas.TextWidth(lab.text) + 20; if aw < 100 then aw := 100;

  if aw > 200 then begin
    aw := 200;
    ACallHint.height := (round ((aw / 200)) + 1) * 38;
  end else begin
    ACallHint.height := 35;
  end;

  ACallHint.Width := aw;

  if ACallHint.Position.X + ACallHint.width > DForm.ClientWidth then begin
    ACallHint.Position.X := DForm.ClientWidth - ACallHint.width-5;
    ACallHint.CalloutOffset := ACallHint.width - 40;
  end else begin
    ACallHint.CalloutOffset := 8;
  end;

  // CAllHint out of sight?
  if ACallHint.Position.Y + ACallHint.Height > DForm.ClientHeight then begin
    ACAllHint.Position.y := ACAllHint.Position.y - ACAllHint.Height - 25;
    ACAllHint.CalloutPosition := TCalloutPosition.cpBottom;
    with Lab.Margins do begin Top := 0; bottom := 10; left := 5; right := 5; end;
    {$IF FireMonkeyVersion <= 17.0} // Workaround XE2-XE3
    lbDummy.Align := TAlignLayout.alBottom;
    {$IFEND}
  end else begin
    with Lab.Margins do begin Top := 10; left := 5; right := 5; bottom :=0; end;
    ACAllHint.CalloutPosition := TCalloutPosition.cpTop;
    {$IF FireMonkeyVersion <= 17.0} // Workaround XE2-XE3
    lbDummy.Align := TAlignLayout.alTop;
    {$IFEND}
  end;

  TT.Interval := TimeBefore;
  TT.Enabled := True;
end;

procedure HintExit(Self, Sender: TObject);
begin
  ACallHint.Visible := false;
  ACallHint.Parent := NIL;
  TT.Enabled := false;
end;

Initialization
  InitHintSetting;
Finalization
  TT.Free;
end.
