{*********************************************************************
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Autor: Brovin Y.D.
 * E-mail: y.brovin@gmail.com
 *
 ********************************************************************}

unit FGX.ActionSheet;

interface

uses
  System.Classes, FMX.Platform, FGX.ActionSheet.Types;

type

  { TfgActionSheet }

  IFGXActionSheetService = interface;

  [ComponentPlatformsAttribute(pidAndroid or pidiOSDevice or pidiOSSimulator)]
  TfgCustomActionSheet = class (TComponent)
  private
    FActions: TfgActionsCollections;
    FUseUIGuidline: Boolean;
    FTitle: string;
    procedure SetActions(const Value: TfgActionsCollections);
  protected
    FActionSheetService: IFGXActionSheetService;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show; virtual;
    function Supported: Boolean;
  public
    property Actions: TfgActionsCollections read FActions write SetActions;
    property UseUIGuidline: Boolean read FUseUIGuidline write FUseUIGuidline default True;
    property Title: string read FTitle write FTitle;
  end;

  TfgActionSheet = class (TfgCustomActionSheet)
  published
    property Actions;
    property UseUIGuidline;
    property Title;
  end;

  { IFGXActionSheetService }

  IFGXActionSheetService = interface
  ['{02E3DA72-905C-4858-B16F-0D6CDFEF9E03}']
    procedure Show(const ATitle: string; Actions: TfgActionsCollections; const UseUIGuidline: Boolean = True);
  end;

implementation

uses
  FMX.Types
{$IFDEF IOS}
   , FGX.ActionSheet.iOS
{$ENDIF}
{$IFDEF ANDROID}
   , FGX.ActionSheet.Android
{$ENDIF}
;

{ TActionSheet }

constructor TfgCustomActionSheet.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FActions := TfgActionsCollections.Create(Self);
  FUseUIGuidline := True;
  TPlatformServices.Current.SupportsPlatformService(IFGXActionSheetService, IInterface(FActionSheetService));
end;

destructor TfgCustomActionSheet.Destroy;
begin
  FActionSheetService := nil;
  FActions.Free;
  inherited Destroy;
end;

procedure TfgCustomActionSheet.SetActions(const Value: TfgActionsCollections);
begin
  Assert(Value <> nil);
  FActions.Assign(Value);
end;

procedure TfgCustomActionSheet.Show;
begin
  if Supported then
    FActionSheetService.Show(Title, Actions, UseUIGuidline);
end;

function TfgCustomActionSheet.Supported: Boolean;
begin
  Result := FActionSheetService <> nil;
end;

initialization
  RegisterFmxClasses([TfgCustomActionSheet, TfgActionSheet]);

{$IF Defined(IOS) OR Defined(ANDROID)}
  RegisterService;
{$ENDIF}
end.
