{*********************************************************************
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Autor: Brovin Y.D.
 * E-mail: y.brovin@gmail.com
 *
 ********************************************************************}
 
unit FGX.Helpers.iOS;

interface

uses
  FMX.Types, iOSapi.UIKit, System.UITypes;

const
  DEFAULT_ANIMATION_DURATION = 0.4;

type
  TInterfaceIdiom = (Desktop, Phone, Tablet);

function InterfaceIdiom: TInterfaceIdiom;

function ColorToNSColor(const AColor: TAlphaColor): UIColor;

implementation

uses
  iOSapi.CoreImage;

function InterfaceIdiom: TInterfaceIdiom;
begin
  if TUIDevice.Wrap(TUIDevice.OCClass.currentDevice).userInterfaceIdiom = UIUserInterfaceIdiomPad then
    Result := TInterfaceIdiom.Tablet
  else
    Result := TInterfaceIdiom.Phone;
end;

function ColorToNSColor(const AColor: TAlphaColor): UIColor;
var
  Red: Single;
  Green: Single;
  Blue: Single;
  Alpha: Single;
  ColorCI: CIColor;
begin
  Red := TAlphaColorRec(AColor).R / 255;
  Green := TAlphaColorRec(AColor).G / 255;
  Blue := TAlphaColorRec(AColor).B / 255;
  Alpha := TAlphaColorRec(AColor).A / 255;
  ColorCI := TCIColor.Wrap(TCIColor.OCClass.colorWithRed(Red, Green, Blue, Alpha));
  Result := TUIColor.Wrap(TUIColor.OCClass.colorWithCIColor(ColorCI));
end;

end.
