{*********************************************************************
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Autor: Brovin Y.D.
 * E-mail: y.brovin@gmail.com
 *
 ********************************************************************}

unit FGX.Helpers.Android;

interface

uses
  FMX.Controls;

/// <summary>
///   We define which native theme we need to use for pickers using meta information in
///   our FMX style (TStyleDescriptor.PlatformTarget)
/// </summary>
/// <remarks>
///   Theme is applyed only on Android Version >= 4.0.
///   If current OS it's Gengebread, we use 0 - default system theme
/// </remarks>
/// <returns>Android System theme consts for Dialogs (THEME_HOLO_LIGHT, THEME_HOLO_DARK)</returns>
function GetNativeTheme: Integer; overload;
function GetNativeTheme(const ATargetControl: TControl): Integer; overload;

implementation

uses
  System.SysUtils,
  Androidapi.JNI.App,
  FMX.Styles, FMX.Forms, FMX.Helpers.Android;

const
  ANDROID_LIGHT_THEME = '[LIGHTSTYLE]';
  ANDROID_DARK_THEME = '[DARKSTYLE]';

function GetNativeTheme(const ATargetControl: TControl): Integer; overload;
var
  StyleDescriptor: TStyleDescription;
begin
  Assert(ATargetControl <> nil);

  Result := 0;
  if not IsGingerbreadDevice and (ATargetControl <> nil) then
  begin
    StyleDescriptor := TStyleManager.GetStyleDescriptionForControl(ATargetControl);
    if Assigned(StyleDescriptor) then
    begin
      if StyleDescriptor.PlatformTarget.Contains(ANDROID_LIGHT_THEME) then
        Result := TJAlertDialog.JavaClass.THEME_HOLO_LIGHT;

      if StyleDescriptor.PlatformTarget.Contains(ANDROID_DARK_THEME) then
        Result := TJAlertDialog.JavaClass.THEME_HOLO_DARK;
    end;
  end;
end;

function GetNativeTheme: Integer;
begin
  if Screen.FocusControl <> nil then
    Result := GetNativeTheme(Screen.FocusControl.GetObject as TControl)
  else
   Result := 0;
end;

end.
