{*********************************************************************
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Autor: Brovin Y.D.
 * E-mail: y.brovin@gmail.com
 *
 ********************************************************************}

unit FGX.ProgressDialog.Types;

interface

type

  /// <summary>
  ///   Base class for implementation native progress/activity dialogs
  /// </summary>
  TfgNativeDialog = class abstract
  private
    FTitle: string;
    FMessage: string;
  protected
    procedure SetTitle(const Value: string); virtual;
    procedure SetMessage(const Value: string); virtual;
  public
    procedure Show; virtual; abstract;
    procedure Hide; virtual; abstract;
  public
    property Message: string read FMessage write SetMessage;
    property Title: string read FTitle write SetTitle;
  end;

  /// <summary>
  ///   Base class for implementation native activity dialogs
  /// </summary>
  TfgNativeActivityDialog = class abstract (TfgNativeDialog);

  /// <summary>
  ///   <para>
  ///     Display mode of progress dialog.
  ///   </para>
  /// </summary>
  ///  <remarks>
  ///   <list type="bullet">
  ///     <item>
  ///       Undeterminated - We temporarily don't know, when operation will start
  ///     </item>
  ///     <item>
  ///       Determinated - We already know and evaluated operation time (in %)
  ///     </item>
  ///   </list>
  ///  </remarks>
  TfgProgressDialogKind = (Undeterminated, Determinated);

  /// <summary>
  ///   Base class for implementation native progress dialogs
  /// </summary>
  TfgNativeProgressDialog = class abstract (TfgNativeDialog)
  private
    FKind: TfgProgressDialogKind;
    FProgress: Single;
  protected
    procedure SetKind(const Value: TfgProgressDialogKind); virtual;
    procedure SetProgress(const Value: Single); virtual;
  public
    property Kind: TfgProgressDialogKind read FKind write SetKind default TfgProgressDialogKind.Undeterminated;
    property Progress: Single read FProgress write SetProgress;
  end;

implementation

uses
  System.Math;

{ TfgNativeDialog }

procedure TfgNativeDialog.SetMessage(const Value: string);
begin
  if Message <> Value then
    FMessage := Value;
end;

procedure TfgNativeDialog.SetTitle(const Value: string);
begin
  if Title <> Value then
    FTitle := Value;
end;

{ TfgNativeProgressDialog }

procedure TfgNativeProgressDialog.SetKind(const Value: TfgProgressDialogKind);
begin
  if Kind <> Value then
    FKind := Value;
end;

procedure TfgNativeProgressDialog.SetProgress(const Value: Single);
begin
  Assert(InRange(Value, 0, 100), 'Progress value must be in range [0..100]');

  if not SameValue(Progress, Value) then
    FProgress := Max(0, Min(100, Value));
end;

end.
