unit landscapeMainForm;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.Types3D, FMX.Objects3D,
  FMX.Layers3D;

type
  TAddable = (aTree, aHouse);

  TMain = class(TForm3D)
    land: TImage3D;
    sun: TLight;
    tree: TCone;
    house: TModel3D;
    walls: TMesh;
    Layer3D1: TLayer3D;
    BtnTree: TButton;
    BtnHouse: TButton;
    Label1: TLabel;
    BtnSun: TButton;
    Label2: TLabel;
    BtnUndo: TButton;
    procedure landMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single; RayPos, RayDir: TVector3D);
    procedure landMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single; RayPos, RayDir: TVector3D);
    procedure landMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Single;
      RayPos, RayDir: TVector3D);
    procedure Form3DCreate(Sender: TObject);
    procedure BtnTreeClick(Sender: TObject);
    procedure BtnHouseClick(Sender: TObject);
    procedure BtnSunClick(Sender: TObject);
    procedure BtnUndoClick(Sender: TObject);
  private
    FMouseDown: Boolean;
    FAddable : TAddable;
    FLastX, FLastZ : Double;
    FSeparation: Double;
    FHouseAngle: Integer;
    FSunAngle: Integer;
  public
  end;

var
  Main: TMain;

implementation

{$R *.fmx}

procedure TMain.Form3DCreate(Sender: TObject);
begin
  FMouseDown := False;
  FAddable := aTree;
  FHouseAngle := 30;
  FSunAngle := -45;
  FSeparation := 0.3;
end;

procedure TMain.landMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Single; RayPos, RayDir: TVector3D);
begin
  FMouseDown := True;
  FLastX := -99;
  FLastZ := -99;
end;

procedure TMain.landMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Single; RayPos, RayDir: TVector3D);
var
  newObj: TProxyObject;
  HitPos: TVector3D;
begin
  if FMouseDown then begin
    land.RayCastIntersect(RayPos, RayDir, HitPos);
    // if moved far enough
    if (Abs(HitPos.X - FLastX) > FSeparation) or (Abs(HitPos.Z - FLastZ) > FSeparation) then begin
      // add new object as a proxy object
      newObj := TProxyObject.Create(self);
      land.AddObject(newObj);
      case FAddable of
        aTree:  begin
          newObj.SourceObject := tree;
          newObj.Scale.Assign(tree.Scale);
          newObj.RotationAngle.Y := tree.RotationAngle.Y;
          FSeparation := 0.3;
        end;
        aHouse: begin
          newObj.SourceObject := walls; // need to point at material !!!
          newObj.Scale.Assign(house.Scale);
          newObj.RotationAngle.Y := house.RotationAngle.Y;
          newObj.RotationAngle.Z := FHouseAngle;
          FSeparation := 1.0;
        end;
      end;

      newObj.Position.Z := newObj.SourceObject.Position.Z;
      newObj.Position.X := HitPos.X;
      newObj.Position.Y := -HitPos.Z;  // Z -> Y

      newObj.HitTest := False;

      FLastX := HitPos.X;
      FLastZ := HitPos.Z;
    end;
  end;
end;

procedure TMain.landMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Single; RayPos, RayDir: TVector3D);
begin
  FMouseDown := False;
end;

procedure TMain.BtnHouseClick(Sender: TObject);
begin
  FAddable := aHouse;
  FHouseAngle := (FHouseAngle + 45) mod 360;
  Label1.Text := IntToStr(FHouseAngle);
end;

procedure TMain.BtnTreeClick(Sender: TObject);
begin
  FAddable := aTree;
end;

procedure TMain.BtnUndoClick(Sender: TObject);
begin
  if land.ChildrenCount > 2 then
    land.RemoveObject(land.ChildrenCount-1);
end;

procedure TMain.BtnSunClick(Sender: TObject);
begin
  FSunAngle := (FSunAngle + 10) mod 360;
  sun.RotationAngle.Y := FSunAngle;
  Label2.Text := IntToStr(FSunAngle);
end;

end.
