unit Unit2;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.Memo,
  FMX.Layouts, FMX.ListBox, FMX.StdCtrls,
  ContactsManager;

type
  TForm2 = class(TForm)
    lbContactsList: TLabel;
    LstContacts: TListBox;
    MemDetails: TMemo;
    lbcontactDetails: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure LstContactsChange(Sender: TObject);
  private
    fContactsManager : TContactsManager;
  public
    { Dclarations publiques }
  end;

var
  Form2: TForm2;

implementation

{$R *.fmx}


{-------------------------------------------------------------------------------
  Procedure: TForm2.FormCreate
  DateTime:  2014.01.02
  Arguments: Sender: TObject
  Result:    None
-------------------------------------------------------------------------------}
procedure TForm2.FormCreate(Sender: TObject);
var i : integer;
begin
  fContactsManager := TContactsManager.Create;

  fContactsManager.ExtractContactsList;

  lbContactsList.Text := Format('Contacts list (%d)',[fContactsManager.ContactsCount]);
  LstContacts.BeginUpdate;
  try
    for i := 0 to fContactsManager.ContactsCount -1 do
    begin
      LstContacts.Items.Add(fContactsManager.Contacts[i].Display_Name);
    end;
  finally
    LstContacts.EndUpdate;
  end;
end;


{-------------------------------------------------------------------------------
  Procedure: TForm2.FormDestroy
  Author:    ehkhalid
  Arguments: Sender: TObject
  Result:    None
-------------------------------------------------------------------------------}
procedure TForm2.FormDestroy(Sender: TObject);
begin
  fContactsManager.Free;
end;


{-------------------------------------------------------------------------------
  Procedure: TForm2.LstContactsChange
  Author:    ehkhalid
  Arguments: Sender: TObject
  Result:    None
-------------------------------------------------------------------------------}
procedure TForm2.LstContactsChange(Sender: TObject);
const
  wCRLF = #13#10;
begin
  if LstContacts.ItemIndex <> -1 then
  begin
    with fContactsManager do
    begin
      lbcontactDetails.Text := wCRLF+
        'ID          : ' + Contacts[LstContacts.ItemIndex].LookupID   + wCRLF+
        'Family Name : ' + Contacts[LstContacts.ItemIndex].FamilyName + wCRLF+
        'First Name  : ' + Contacts[LstContacts.ItemIndex].FirstName  + wCRLF+
        'Email       : ' + Contacts[LstContacts.ItemIndex].Email      + wCRLF+
        'Phone       : ' + Contacts[LstContacts.ItemIndex].Phone;
    end;
  end;
end;

end.
