unit UAIMLLoader;

interface
uses
    UPatternMatcher, SysUtils, OXmlPDOM;
type

  TAIMLLoader=class
    _pattern,
    _that,
    _topic:string;

    _template:string;
    procedure TopicEnd;
    procedure LoadFromFile(AFileName : string);

    function ParseAIMLElement(APNode : PXMLNode) : Boolean;
    function ParseCategoryElement(APNode : PXMLNode) : Boolean;
    function ParseTopicElement(APNode : PXMLNode) : Boolean;
    function ParseTemplateElement(APNode : PXMLNode) : Boolean;
    function ParsePatternElement(APNode : PXMLNode) : Boolean;
    function ParseThatElement(APNode : PXMLNode) : Boolean;

    function GetChildXML(APNode : PXMLNode) : string;

  end;
var
  AIMLLoader:TAIMLLoader;

implementation
  uses System.IOUtils,UVariables,ULogging;


  const max_content_size=20480;
  Procedure TAIMLLoader.TopicEnd;
    begin
      _topic:='*';
    end;

function TAIMLLoader.ParseAIMLElement(APNode: PXMLNode): Boolean;
var
    lNode : PXMLNode;
begin
    _topic := '*';
    Result := true;
    lNode := nil;
    while APNode.GetNextChild(lNode) do
    begin
        if lNode.NodeName = 'category' then
        begin
            ParseCategoryElement(lNode);
        end;
        if lNode.NodeName = 'topic' then
            ParseTopicElement(lNode);
    end;
    TopicEnd;
end;

function TAIMLLoader.ParseCategoryElement(APNode: PXMLNode): Boolean;
var
    lNode : PXMLNode;
begin
    _that := '*';
    Result := true;
    lNode := nil;
    while APNode.GetNextChild(lNode) do
    begin
        if lNode.NodeName = 'template' then
        begin
            Result := ParseTemplateElement(lNode);
        end;
        if lNode.NodeName = 'pattern' then
        begin
            Result := ParsePatternElement(lNode);
        end;
        if lNode.NodeName = 'that' then
        begin
            Result := ParseThatElement(lNode);
        end;
    end;

    if Result then
    begin
        if _that='' then _that:='*';
        PatternMatcher.add(_pattern+' <that> '+_that+' <topic> '+_topic,_template);
    end;
    if (PatternMatcher._count mod 5000)=0 then
        log.Log('aimlloader',Inttostr(PatternMatcher._count)+' categories...');
end;

function TAIMLLoader.ParsePatternElement(APNode: PXMLNode): Boolean;
begin
    _pattern := GetChildXML(APNode);
    Result := not _pattern.IsEmpty;
    {while (result)and(Parser.Scan) do begin
    case Parser.CurPartType of
      ptContent:_pattern:=_pattern+' '+Parser.CurContent;
      ptEmptyTag: if (Parser.CurName='bot') then
                    result:=PAtternBotElement
                  else
                    result:=false;
      ptEndTag: if (Parser.CurName='pattern') then break
                else result:=false;
      ptComment:;
    else
      result:=false;
    end;
    end; }
end;

function TAIMLLoader.ParseTemplateElement(APNode: PXMLNode): Boolean;
begin
    _template := GetChildXML(APNode);
    Result := not _template.IsEmpty;
end;

function TAIMLLoader.ParseThatElement(APNode: PXMLNode): Boolean;
begin
    _that := GetChildXML(APNode);;
    Result := not _that.IsEmpty;
    if _that = '' then
        _that:='*';
    {while (result)and(Parser.Scan)  do begin
    case Parser.CurPartType of
      ptContent:_that:=_that+' '+Parser.CurContent;
      ptEndTag: if (Parser.CurName='that') then break
                else result:=false;
      ptComment:;
    else
      result:=false;
    end;
    end;
    if _that='' then _that:='*';}
end;

function TAIMLLoader.ParseTopicElement(APNode: PXMLNode): Boolean;
var
    lNode : PXMLNode;
begin
    _topic := APNode.Attributes['name'];
    lNode := nil;
    while APNode.GetNextChild(lNode) do
    begin
        if lNode.NodeName = 'category' then
        begin
            ParseCategoryElement(lNode);
        end;
    end;
end;

function TAIMLLoader.GetChildXML(APNode: PXMLNode): string;
var
    lNode : PXMLNode;
begin
    Result := EmptyStr;
    lNode := nil;
    while APNode.GetNextChild(lNode) do
    begin
        Result := Result + ' ' + lNode.XML;
    end;
end;

procedure TAIMLLoader.LoadFromFile(AFileName: string);
var
    search : TSearchRec;
    dir : string;
    name : string;
    i : integer;
    Root, lChildNode: PXMLNode;
    FXML: IXMLDocument;
begin
    {$IFDEF MSWINDOWS}
    for i:=1 to length(AFileName) do
        if AFileName[i]='/' then
            AFileName[i] := TPath.DirectorySeparatorChar;
    {$ELSE}
    for i:=0 to length(AFileName)-1 do
        if AFileName[i]='/' then
            AFileName[i] := TPath.DirectorySeparatorChar;
    {$ENDIF}
    dir := ExtractFilePath(AFileName);
    dir := TPath.Combine(System.SysUtils.IncludeTrailingPathDelimiter(TPath.GetDocumentsPath) +
        'PASCAlice', dir);

    FXML := CreateXMLDoc;

    if Findfirst(TPath.Combine(System.SysUtils.IncludeTrailingPathDelimiter(TPath.GetDocumentsPath) +
        'PASCAlice',AFileName),0,search) =0 then
    repeat
        name:=TPath.Combine(dir,Search.Name);
        if not TFile.Exists(name) then begin
            log.log('aimlloader','Warning: '+Name+' not found');
            continue;
        end;
        log.log('aimlloader','Loading ' + name);
        if not FXML.LoadFromFile(name) then
        begin
            log.log('aimlloader','Loading Failed ' + name);
            Continue;
        end;
        Root := FXML.DocumentElement;
        Root.Normalize;
            if Root.NodeName = 'aiml' then
                ParseAIMLElement(Root);
    until FindNext(search)<>0;
    FindClose(search);
   Log.log('aimlloader','Done, loaded '+InttoStr(PatternMatcher._count)+' categories');
end;

end.

