{This unit contains classes to process template elements}
unit UElements;

interface
implementation
uses
  UElementFActory,UPatternMatcher,UVariables,UAIMLLoader,UTemplateProcessor,
  SysUtils,classes,UUtils,
  System.Generics.Collections,
  OXmlPDOM;

type
  TBotElement=class(TTEmplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TxStarElement=class(TTEmplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;
type
  TGetElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;
type
  TSetElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TDefaultElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TLearnElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;
type
  TSrElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TThinkElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TSraiElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TRandomElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TBrElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TConditionElement=class(TTemplateElement)
    //function blockMulti(Match:TMatch;Parser:TXMLParser):string;
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    function blockConditionOXML(AVar, AValue: string; AMatch: TMatch;
        APNode : PXMLNode):string;
    function blockSwitchOXML(AVar: string; AMatch: TMatch; APNode : PXMLNode):string;

    procedure register;override;
  end;
type
  TCaseElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TThatElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TVersionElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TidElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TSizeElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TDateElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TGossipElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TInputElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TSubstElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TJScriptElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TSystemElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;

type
  TforgetElement=class(TTemplateElement)
    function ProcessOXML(AMatch:TMatch; APNode : PXMLNode):string; override;
    procedure register;override;
  end;


function TSetElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
var
    name:string;
begin
    name := APNode.Attributes['name'];
    Result := ProcessContentsOXML(AMatch, APNode);
    Result := TrimWS(ConvertWs(result, true));
    Memory.setVar(name, Result);
end;

procedure TSetElement.register;
    begin
      ElementFactory.register('set',self);
    end;


function TBotElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    result := Memory.getProp(APNode.Attributes['name']);
end;

procedure TBotElement.register;
    begin
      ElementFactory.register('bot',Self);
    end;

function TGetElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    Result := Memory.getVar(APNode.Attributes['name']);
    if Result.IsEmpty then
        Result := ProcessContentsOXML(AMatch, APNode);
    {if (Parser.CurPartType=ptEmptyTag) or
     (Parser.CurPartType=ptEndTag) then exit;}
    {if not Result.IsEmpty then
    repeat until
      (not parser.Scan)or
      ((parser.CurPartType=ptEndTag)and
       (parser.CurName='get'))
    else
    result:=ProcessContents(Match,Parser); }
end;

procedure TGetElement.register;
    begin
      ElementFactory.register('get',Self);
    end;


function TxStarElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
var
    context:integer;
    index:string;
begin
  try
    if APNode.NodeName = 'star' then
        context:=0;
    if APNode.NodeName = 'thatstar' then
        context:=1;
    if APNode.NodeName = 'topicstar' then
        context:=2;
    index := APNode.Attributes['index'];
    if index = '' then
        index:='1';
    Result := AMatch.get(context, strtoint(index));
    Result := TrimWS(Result);
  except
    on e : exception do
        Result := EmptyStr;
  end;
end;

procedure TxStarElement.register;
    begin
      ElementFactory.register('star',self);
      ElementFactory.register('thatstar',self);
      ElementFactory.register('topicstar',self);
    end;

{  function TDefaultElement.Process(Match:TMatch;Parser:TXMLParser):string;
    begin
      SetLength(result,Parser.CurFinal-Parser.CurStart+1);
      result:=StrLCopy(MarshaledString(result),Parser.CurStart,Parser.CurFinal-Parser.CurStart+1);
    end;         }

function TDefaultElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    raise Exception.Create('ProcessOXML Unknown');
end;

procedure TDefaultElement.register;
    begin
      ElementFactory.registerdefault(Self);
    end;

function TLearnElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    Result := EmptyStr;
    Result := ProcessContentsOXML(AMatch, APNode);
    if not assigned(AIMLLoader) then
        AIMLLoader := TAIMLLoader.Create;
    //AIMLLoader.load(result);
    AIMLLoader.LoadFromFile(result)
end;

procedure TLearnElement.register;
    begin
      ElementFactory.register('learn',Self);
    end;


function TSrElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
var
    temp : TMatch;
begin
    temp := PatternMatcher.Matchinput(AMatch.get(0,1));
    try
        Result := TemplateProcessor.ProcessOXML(temp);
    finally
        temp.free;
    end;

    {if parser.curPartType=ptStartTag then
    while (parser.scan) and (parser.curparttype<>ptEndTag) and (parser.curName<>'sr') do;   }
end;

procedure TSrElement.register;
    begin
      ElementFactory.register('sr',Self);
    end;

function TThinkElement.ProcessOXML(AMatch:TMatch; APNode: PXMLNode): string;
begin
    ProcessContentsOXML(AMatch, APNode);
    Result := EmptyStr;
end;

procedure TThinkElement.register;
    begin
      ElementFactory.register('think',Self);
    end;


function TSraiElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
var
    temp:TMatch;
begin
    Result := ProcessContentsOXML(AMatch, APNode);
    if Result.IsEmpty then
    begin
        temp := PatternMatcher.Matchinput(AMatch.get(0,1));
        try
            Result := TemplateProcessor.ProcessOXML(temp);
        finally
            temp.free;
        end;
    end
    else
    begin
        temp := PatternMatcher.Matchinput(Result);
        try
            Result := TemplateProcessor.ProcessOXML(temp);
        finally
            temp.free;
        end;
    end;
end;

procedure TSraiElement.register;
    begin
      ElementFactory.register('srai',Self);
    end;


function TRandomElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
var
    lNode : PXMLNode;
    lList : TList<PXMLNode>;
    lName : string;
    lRandom : integer;
begin
    lList := TList<PXMLNode>.Create;
    try
        Result := EmptyStr;
        lNode := nil;
        while APNode.GetNextChild(lNode) do
        begin
            if lNode.NodeName = 'li' then
                lList.Add(lNode)
            else
                if lNode.NodeName = 'random' then
                begin
                    break;
                end;
        end;
        for lNode in lList do
            lName := lNode.Xml;

        lRandom := Random(lList.Count);
        //lRandom := 0;
        lNode := lList.Items[lRandom];
        Result := ProcessContentsOXML(AMatch, lNode);
    finally
        FreeAndNil(lList);
    end;
end;

procedure TRandomElement.register;
    begin
      Randomize;
      ElementFactory.register('random',Self);
    end;

function TConditionElement.blockConditionOXML(AVar, AValue: string;
  AMatch: TMatch; APNode: PXMLNode): string;
begin
    if AnsiCompareStr(Memory.getVar(AVar), AValue) = 0 then
    begin
        Result := ProcessContentsOXML(AMatch, APNode);
    end
    else
        Exit(EmptyStr);
end;


function TConditionElement.blockSwitchOXML(AVar: string; AMatch: TMatch;
  APNode: PXMLNode): string;
var
    curval: string;
    curvar: string;
    defaultitem: boolean;
    nvItem: boolean; {<li name="xx" value=""></li>}
    vItem: boolean;  {<li name="xx" value=""></li>}
    lChildNode: PXMLNode;
begin
    Result := EmptyStr;
    lChildNode := nil;
    while APNode.GetNextChild(lChildNode) do
    begin
        if lChildNode.NodeName = 'li' then
        begin
            curval := lChildNode.Attributes['value'];
            curvar := lChildNode.Attributes['name'];
            defaultItem := lChildNode.AttributeCount = 0;
            nvItem := (lChildNode.AttributeCount = 2) and
                AnsiSameStr(Memory.getVar(curvar), curval);
            vItem := (not AVar.IsEMpty) and AnsiSameStr(Memory.getVar(AVar), curval);
            if (defaultItem or nvItem or vItem) then
            begin
                Result := ProcessContentsOXML(AMatch, lChildNode);
                break;
            end;
        end;
    end;
end;

function TConditionElement.ProcessOXML(AMatch: TMatch;
    APNode: PXMLNode): string;
var
    mainval: string;
    mainvar: string;
begin
    mainval := APNode.Attributes['value'];
    mainvar := APNode.Attributes['name'];
    if (not mainvar.IsEmpty) and (not mainval.IsEmpty) then //Parser.CurAttr.Node('value')<>nil
    begin
        Result := blockConditionOXML(mainvar, mainval, AMatch, APNode);
    end
    else
        if (mainval.IsEmpty) then //WTF?
        begin
            Result := blockSwitchOXML(mainvar, AMatch, APNode);
        end;
end;

procedure TConditionElement.register;
    begin
      ElementFactory.register('condition',Self);
    end;
{  function TBrElement.Process(Match:TMatch;Parser:TXMLParser):string;
    begin
      result:=' ';
    end;           }

function TBrElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    Result := EmptyStr;
end;

procedure TBrElement.register;
    begin
      ElementFactory.register('br',Self);
    end;

function TCaseElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
var
    specificElement: string;
    upstr: string;
    i: integer;
begin
    Result := EmptyStr;
    specificElement := APNode.NodeName;
    Result := ProcessContentsOXML(AMatch, APNode);
    Result := convertWS(Result, true);
    if SpecificElement.Equals('uppercase') then
        Result := AnsiUpperCase(Result)
    else
        if SpecificElement.Equals('lowercase') then
            Result := AnsiLowerCase(Result)
        else
            if (SpecificElement.Equals('formal') and (not Result.IsEmpty)) then
            begin
                upstr := AnsiUpperCase(Result);
                Result[1] := upstr[1];
                for i:=1 to length(Result)-1 do
                  if Result[i]=' ' then
                    Result[i+1] := upstr[i+1];
            end
            else
                if SpecificElement.Equals('sentence') then
                    Result[1] := AnsiUpperCase(Result)[1];
end;

procedure TCaseElement.register;
    begin
      ElementFactory.register('uppercase',Self);
      ElementFactory.register('lowercase',Self);
      ElementFactory.register('formal',Self);
      ElementFactory.register('sentence',Self);
    end;


function TThatElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
var
    thisTag : string;
begin
    ThisTag := APNode.NodeName;
    if ThisTag = 'botsaid' then
        thistag := 'that';
    if APNode.AttributeCount <> 0 then
        result := ''
    else
        if ThisTag = 'that' then
            result := Memory.getVar('that')
        else
            if ThisTag = 'justbeforethat' then
                result := Memory.getVar('that',1);
end;

procedure TThatElement.register;
    begin
      ElementFactory.register('that',Self);
      ElementFactory.register('justbeforethat',Self);
      ElementFactory.register('botsaid',Self);
    end;


function TVersionElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    result := 'PASCAlice v1.5';
end;

procedure TVersionElement.register;
    begin
      ElementFactory.register('version',Self);
      ElementFactory.register('getversion',Self);
    end;


function TidElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    result := '0';
end;

procedure TIdElement.register;
    begin
      ElementFactory.register('id',Self);
      ElementFactory.register('get_ip',Self);
    end;

function TSizeElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    Result := inttostr(PatternMatcher._count);
end;

procedure TSizeElement.register;
    begin
      ElementFactory.register('size',Self);
      ElementFactory.register('getsize',Self);
    end;


function TDateElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    result := DatetoStr(now);
end;

procedure TDateElement.register;
    begin
      ElementFactory.register('date',Self);
    end;

function TGossipElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    result := ProcessContentsOXML(AMatch, APNode);
    WrFile('gossip.log',result);
end;

procedure TGossipElement.register;
    begin
      ElementFactory.register('gossip',Self);
    end;

function TInputElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
var
    thisTag : string;
    i : integer;
    si : string;
begin
    ThisTag := APNode.NodeName;
    if ThisTag = 'input' then
    begin
        si := APNode.Attributes['index'];
        if si<> '' then
          i := strtoint(si)-1
        else
          i := 0;
        result := Memory.getVar('input',i)
    end
    else
        if ThisTag = 'justthat' then
            result := Memory.getVar('input',1)
        else
            if ThisTag = 'beforethat' then
                result := Memory.getVar('input',2);
end;

procedure TInputElement.register;
    begin
      ElementFactory.register('input',Self);
      ElementFactory.register('justthat',Self);
      ElementFactory.register('beforethat',Self);
    end;

function TSubstElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    if APNode.Text.IsEmpty then
        result := AMatch.get(0,1)
    else
        result := '';
end;

procedure TSubstElement.register;
    begin
      ElementFactory.register('person',Self);
      ElementFactory.register('person2',Self);
      ElementFactory.register('gender',Self);
    end;

function TJScriptElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    Result := APNode.Attributes['alt'];
end;

procedure TJScriptElement.register;
    begin
      ElementFactory.register('javascript',Self);
    end;

function TSystemElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    Result := APNode.Attributes['alt'];
end;

procedure TSystemElement.register;
    begin
      ElementFactory.register('system',Self);
    end;


function TforgetElement.ProcessOXML(AMatch: TMatch; APNode: PXMLNode): string;
begin
    result := EmptyStr;
    Memory.ClearVars;
end;

procedure TForgetElement.register;
    begin
      ElementFactory.register('forget',Self);
    end;

begin
  if not assigned(ElementFactory) then ElementFactory:=TElementFactory.Create;
  TBotElement.Create;
  TDefaultElement.Create;
  TGetElement.Create;
  TxStarElement.Create;
  TLearnElement.Create;
  TSetElement.Create;
  TSrElement.Create;
  TThinkElement.Create;
  TSraiElement.Create;
  TRandomElement.Create;
  TConditionElement.Create;
  TBrElement.Create;
  TCaseElement.Create;
  TThatElement.Create;
  TVersionElement.Create;
  TIdElement.Create;
  TSizeElement.Create;
  TDateElement.Create;
  TGossipElement.Create;
  TInputElement.Create;
  TsubstElement.Create;
  TJscriptElement.Create;
  TsystemElement.Create;

  TForgetElement.Create;

end.
