unit UBotLoader;

interface
uses
    UAIMLLoader,classes, UPAtternMatcher, OXmlPDOM, AnonThread;
type
  TBotLoader=class
    loaded:boolean;
    FXML: IXMLDocument;
    procedure LoadFromText(AText : string);
    procedure LoadFromFile(AFileName : string);

    function ParseBotElement(APNode : PXMLNode) : Boolean;
    function ParsePropertyElement(APNode : PXMLNode) : Boolean;
    function ParseLearnElement(APNode : PXMLNode) : Boolean;
    function ParseSentenceSplitters(APNode : PXMLNode) : Boolean;
    function ParseInputSubstitutions(APNode : PXMLNode) : Boolean;
    procedure LoadStartup;
  end;
var
  Botloader:TBotLoader;
implementation
uses
    System.IOUtils,System.SysUtils,UVariables,ULogging,UUtils;


procedure TBotLoader.LoadStartup;
var
FThread: TAnonymousThread<Boolean>;
begin
  FThread := TAnonymousThread<Boolean>.Create(
    function: Boolean
    var
        lFileName : string;
    begin
      // Runs in seperate thread
      lFileName := System.SysUtils.IncludeTrailingPathDelimiter(TPath.GetDocumentsPath) +
      'PASCAlice' + TPath.DirectorySeparatorChar + 'startup.xml';
      BotLoader.LoadFromFile(lFileName);

      Result := True;
    end,
    procedure(AResult: Boolean)
    begin
      // Runs in main thread
      // process the result from above
    end,
    procedure(AException: Exception)
    begin
      // Runs in main thread
      // do something if there is an exception
    end,
    False);
end;


function TBotLoader.ParseBotElement(APNode: PXMLNode): Boolean;
var
    lNumprops : integer;
    lBot_ID : string;
    lNode : PXMLNode;
begin
    Result := True;
    lNumprops := 0;
    lBot_ID := APNode.Attributes['id'];
    if AnsiSameStr(APNode.Attributes['enabled'],'false') then
    Begin
        Log.Log('botloader','bot '''+lBot_ID+''' disabled');
        Exit;
    end;
    Log.Log('botloader','Loading bot '''+lBot_ID+'''');
    Log.OpenChatLog(lBot_ID);
    Memory.bot_ID := lBot_ID;
    Memory.Load;
    lNode := nil;
    while APNode.GetNextChild(lNode) do
    begin
        if lNode.NodeName = 'property' then
        begin
            if ParsePropertyElement(lNode) then
                inc(lNumprops);
        end
        else
            if lNode.NodeName = 'learn' then
                ParseLearnElement(lNode);
    end;
    Log.log('botloader','Loaded '+inttostr(lNumprops)+ ' properties.');
end;

function TBotLoader.ParseInputSubstitutions(APNode: PXMLNode): Boolean;
var
    lFrom, lTo:string;
    count : integer;
    lNode : PXMLNode;
begin
    count := 0;
    Result := true;
    lNode := nil;
    while APNode.GetNextChild(lNode) do
    begin
        if lNode.NodeName = 'substitute' then
        begin
            lFrom := lNode.Attributes['find'];
            lTo := lNode.Attributes['replace'];
            Preprocessor.add(lFrom, lTo);
            inc(count);
        end;
    end;
    Log.Log('botloader','Loaded ' + inttostr(count) + ' input substitutions');
end;

function TBotLoader.ParseLearnElement(APNode: PXMLNode): Boolean;
var
    lNode : PXMLNode;
    lVal : string;
begin
    lVal := APNode.Text;
    if not lVal.IsEmpty then
    begin
        //AIMLLoader.load(lVal);
        AIMLLoader.LoadFromFile(lVal);
        loaded := true;
        Result := true;
    end
    else
        Result := False;
end;

function TBotLoader.ParsePropertyElement(APNode: PXMLNode): Boolean;
var
    prop, val : string;
begin
    Result := true;
    prop := APNode.Attributes['name'];
    val := APNode.Attributes['value'];

    if prop.IsEmpty or val.IsEmpty then
        Exit(False);

    Memory.setProp(prop,val);
end;

function TBotLoader.ParseSentenceSplitters(APNode: PXMLNode): Boolean;
var
  val : string;
  count : integer;
  lNode : PXMLNode;
begin
    count := 0;
    result := true;
    lNode := nil;
    while APNode.GetNextChild(lNode) do
    begin
        if lNode.NodeName = 'splitter' then
        begin
            val := lNode.Attributes['value'];
            if not val.IsEmpty then
                SentenceSplitterChars := SentenceSplitterChars + val;
            inc(count);
        end;
    end;
    Log.Log('botloader','Loaded ' + inttostr(count) + ' sentence splitters');
end;

procedure TBotLoader.LoadFromFile(AFileName: string);
var
    lText : string;
begin
    Log.Log('botloader','Loading ' + AFileName + '...');
    if not TFile.Exists(AFileName) then
        Exit;
    lText := TFile.ReadAllText(AFileName);
    Self.LoadFromText(lText);
end;

procedure TBotLoader.LoadFromText(AText: string);
var
    Root, lChildNode: PXMLNode;
begin
    if loaded then
    begin
        Log.Log('botloader','A bot is aready loaded');
        exit; {don't load 2 bots at 1 time}
    end;
    if AText.IsEmpty then
        Exit;
    FXML := CreateXMLDoc;
    if not FXML.LoadFromXML(AText) then
        Exit;
    Root := FXML.DocumentElement;
    Root.Normalize;
    //iterate through all child nodes -> you MUST set the node to nil
    lChildNode := nil;
    while Root.GetNextChild(lChildNode) do
    begin
        if lChildNode.NodeName = 'bot' then
            ParseBotElement(lChildNode)
        else
            if lChildNode.NodeName = 'sentence-splitters' then
                ParseSentenceSplitters(lChildNode)
            else
                if lChildNode.NodeName = 'input' then
                    ParseInputSubstitutions(lChildNode);
    end;
    Log.Log('botloader','Done.');
    Log.Log('botloader',inttostr(Nodecount));
end;

end.

