unit UChat;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  FMX.Layouts, FMX.Controls.Presentation, FMX.ScrollBox, FMX.Memo, UBotloader, UUtils,
  FMX.Objects, FMX.WebBrowser, System.IOUtils, System.Threading, FMX.Media, Data.Cloud.CloudAPI,
  AndroidTTS, FMX.TabControl, FMX.Edit
  ;

type
  TChat = class(TForm)
    Layout1: TLayout;
    Button1: TButton;
    Image1: TImage;
    Timer1: TTimer;
    MediaPlayer1: TMediaPlayer;
    TTS: TAndroidTTS;
    DefaultAIML: TMemo;
    KnowledgeAIML: TMemo;
    GeographyAIML: TMemo;
    PartsAIML: TMemo;
    ReduceAIML: TMemo;
    ThatAIML: TMemo;
    UpdateAIML: TMemo;
    ForgetAIML: TMemo;
    FormatAIML: TMemo;
    InterfaceAIML: TMemo;
    NameGameAIML: TMemo;
    ProtectedAIML: TMemo;
    StartupXML: TMemo;
    TabControl: TTabControl;
    TabItem1: TTabItem;
    TabItem2: TTabItem;
    VSB: TVertScrollBox;
    WBRect: TRectangle;
    ToolBar1: TToolBar;
    KBRect: TRectangle;
    Edit1: TEdit;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormVirtualKeyboardHidden(Sender: TObject;
      KeyboardVisible: Boolean; const Bounds: TRect);
    procedure FormVirtualKeyboardShown(Sender: TObject;
      KeyboardVisible: Boolean; const Bounds: TRect);
    procedure Edit1KeyUp(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
  private
    _SentenceSplitter:TStringTokenizer;
    CanPlay: Boolean;
    BrowserList: TStringList;
    LastMessage: String;
    Procedure Add(s:string);
  public
    { Public declarations }
    procedure ShowBrowser(Sender: TObject);
    Procedure AddUserInput(s:string);
    Procedure AddBotReply(s:string);
    Procedure AddLogMessage(s:string);
    procedure AddUserBubble(S: String);
    procedure AddBotBubble(S: String);
    procedure AddBotBrowser(const S: String);
    procedure AddBotForm(S: String);
    procedure PlaySound(S: String);
    procedure SpeedButtonClicked(Sender: TObject);
  end;

var
  Chat: TChat;
  FAppFolder : string;
const
  VoiceRSS_API_KEY = 'your_api_key_here';

implementation

uses
  uFormWizard,UAIMLLoader,UPatternMatcher,UTemplateProcessor,UVariables,ULogging,UElementFactory,
  UDebug, System.Math;

{$R *.fmx}

Procedure TChat.Add(s:string);
  begin
    TThread.Synchronize(nil,
    procedure
    begin
        AddBotBubble(S);
    end
    );
  end;
Procedure TChat.AddUserInput(s:string);
  var name:string;
  begin
    TThread.Synchronize(nil,
    procedure
    begin
        AddUserBubble(S);
        name:=Memory.getVar('name');
        if name='' then name:='user';
        Log.chatlog(name,s);
    end
    );
  end;
Procedure TChat.AddBotReply(s:string);
  begin
    TThread.Synchronize(nil,
    procedure
    begin
        if s='' then exit;
        Add(s);
        Log.Chatlog(Memory.GetProp('name'),s);
    end
    );

  end;
Procedure TChat.AddLogMessage(s:string);
  begin
    // uncomment this for loading status messages
    //Add(s);
  end;

procedure TChat.PlaySound(S: String);
begin
  if (CanPlay=True) then
   begin
    {$IFDEF ANDROID}
      TTS.Speak(S);
    {$ELSE}
      mediaplayer1.Stop;
      mediaplayer1.Clear;
      try
      // comment out to use Voice RSS instead of Google Translate
      mediaplayer1.FileName := 'http://translate.google.com/translate_tts?ie=UTF-8&total=1&idx=0&textlen=32&client=tw-ob&q='+URLEncode(S)+'&tl=En-gb';
      // Set VoiceRSS_API_KEY and uncomment to use VoiceRSS instead of Google Translate
      //mediaplayer1.FileName := 'https://api.voicerss.org/?key='+VoiceRSS_API_KEY+'&src='+URLEncode(S)+'&hl=en-us&r=0&c=MP3&f=8khz_8bit_mono';
      mediaplayer1.Play;
      except
      end;
    {$ENDIF}
  end;
end;

procedure TChat.SpeedButtonClicked(Sender: TObject);
begin
  if TSpeedButton(Sender).TagString='chocolateyes' then
   begin
    AddBotBrowser('https://www.google.com/#q='+'chocolate');
   end;
  if TSpeedButton(Sender).TagString='strawberryyes' then
   begin
    AddBotBrowser('https://www.google.com/#q='+'strawberry');
   end;
end;

procedure TChat.ShowBrowser(Sender: TObject);
begin
 TWebBrowser(TRectangle(Sender).TagObject).Visible := True;
 TRectangle(Sender).Visible := False;
end;

procedure TChat.AddBotForm(S: String);
var
CR: TCalloutRectangle;
L: TText;
TmpImg: TImage;
FW: TFormWizard;
BG: TLayout;
begin
  CR := TCalloutRectangle.Create(Self);
  CR.Align := TAlignLayout.alTop;
  CR.CalloutPosition := TCalloutPosition.cpRight;
  CR.Margins.Top := 10;
  CR.Margins.Bottom := 10;
  CR.Margins.Left := 5;
  CR.Height := 350;
  CR.XRadius := 10;
  CR.YRadius := 10;
  CR.Fill.Color := TAlphaColorRec.Lightblue;
  CR.Stroke.Kind := TBrushKind.None;

  BG := TLayout.Create(Self);
  BG.Parent := CR;
  BG.Align := TAlignLayout.alTop;
  BG.Height := 50;

  L := TText.Create(Self);
  L.Parent := BG;
  L.Align := TAlignLayout.alClient;
  L.Text := 'Is this what you were looking for?';
  L.Margins.Top := 10;
  L.Margins.Right := 15;
  L.Margins.Left := 5;
  L.Width := CR.Width-20;
  L.TextSettings.HorzAlign := TTextAlign.Center;
  L.TextSettings.VertAlign := TTextAlign.Center;

  L.WordWrap := True;
  L.AutoSize := True;

  TmpImg := TImage.Create(Self);
  TmpImg.Parent := BG;
  TmpImg.Align := TAlignLayout.alLeft;
  TmpImg.Bitmap.Assign(Image1.Bitmap);
  TmpImg.Width := 50;

  FW := TFormWizard.Create(Self);
  FW.Name := 'FW'+RandomRange(1000,99999999).ToString;
  FW.Parent := CR;
  FW.Align := TAlignLayout.alClient;
  FW.PopulateForm(S);
  FW.Margins.Right := 25;
  FW.Margins.Left := 25;
  FW.Margins.Bottom := 25;

  CR.Parent := VSB;

  PlaySound(L.Text);
end;

procedure TChat.AddBotBrowser(const S: String);
var
CR: TCalloutRectangle;
L: TText;
TmpImg: TImage;
WB: TWebBrowser;
BG: TLayout;
R: TRectangle;
begin
  CR := TCalloutRectangle.Create(Self);
  CR.Align := TAlignLayout.alTop;
  CR.CalloutPosition := TCalloutPosition.cpRight;
  CR.Margins.Top := 10;
  CR.Margins.Bottom := 10;
  CR.Margins.Left := 5;
  CR.Height := 60;
  CR.XRadius := 10;
  CR.YRadius := 10;
  CR.Fill.Color := TAlphaColorRec.Lightblue;
  CR.Stroke.Kind := TBrushKind.None;

  BG := TLayout.Create(Self);
  BG.Parent := CR;
  BG.Align := TAlignLayout.alTop;
  BG.Height := 50;

  L := TText.Create(Self);
  L.Parent := BG;
  L.Align := TAlignLayout.alClient;
  L.Text := 'Is this what you were looking for?';
  L.Margins.Top := 10;
  L.Margins.Right := 15;
  L.Margins.Left := 5;
  L.Width := CR.Width-20;
  L.TextSettings.HorzAlign := TTextAlign.Center;
  L.TextSettings.VertAlign := TTextAlign.Center;

  L.WordWrap := True;
  L.AutoSize := True;

  TmpImg := TImage.Create(Self);
  TmpImg.Parent := BG;
  TmpImg.Align := TAlignLayout.alLeft;
  TmpImg.Bitmap.Assign(Image1.Bitmap);
  TmpImg.Width := 50;


  if BrowserList.Count>0 then
   begin
    WB := TWebBrowser(BrowserList.Objects[0]);
    BrowserList[0] := S;
   end
  else
   begin
    WB := TWebBrowser.Create(Self);
    WB.Parent := WBRect;
    WB.Align := TAlignLayout.alClient;
    BrowserList.AddObject(S,WB);
   end;

  WB.URL := S;


  CR.Parent := VSB;

  PlaySound(L.Text);

  TabControl.ActiveTab := TabItem2;

end;

procedure TChat.AddBotBubble(S: String);
var
CR: TCalloutRectangle;
L: TText;
TmpImg: TImage;
begin
  CR := TCalloutRectangle.Create(Self);
  CR.Align := TAlignLayout.alTop;
  CR.CalloutPosition := TCalloutPosition.cpRight;
  CR.Margins.Top := 10;
  CR.Margins.Bottom := 10;
  CR.Margins.Left := 5;
  CR.Height := 60;
  CR.XRadius := 10;
  CR.YRadius := 10;
  CR.Fill.Color := TAlphaColorRec.Lightblue;
  CR.Stroke.Kind := TBrushKind.None;

  L := TText.Create(Self);
  L.Parent := CR;
  L.Align := TAlignLayout.alClient;
  L.Text := S;
  L.Margins.Top := 10;
  L.Margins.Right := 15;
  L.Margins.Left := 5;
  L.Width := CR.Width-20;
  L.TextSettings.HorzAlign := TTextAlign.Center;
  L.TextSettings.VertAlign := TTextAlign.Center;

  L.WordWrap := True;
  L.AutoSize := True;

  TmpImg := TImage.Create(Self);
  TmpImg.Parent := CR;
  TmpImg.Align := TAlignLayout.alLeft;
  TmpImg.Bitmap.Assign(Image1.Bitmap);
  TmpImg.Width := 50;

  CR.Parent := VSB;

  PlaySound(S);
end;

procedure TChat.AddUserBubble(S: String);
var
CR: TCalloutRectangle;
L: TText;
TmpImg: TImage;
begin
  CR := TCalloutRectangle.Create(Self);
  CR.Align := TAlignLayout.alTop;
  CR.CalloutPosition := TCalloutPosition.cpLeft;
  CR.Margins.Top := 10;
  CR.Margins.Bottom := 10;
  CR.Margins.Right := 5;
  CR.Height := 50;
  CR.XRadius := 10;
  CR.YRadius := 10;
  CR.Stroke.Kind := TBrushKind.None;

  L := TText.Create(Self);
  L.Parent := CR;
  L.Align := TAlignLayout.alClient;
  L.Text := S;
  L.Margins.Top := 10;
  L.Margins.Left := 15;
  L.Margins.Right := 5;
  L.Width := CR.Width-20;
  L.TextSettings.HorzAlign := TTextAlign.Center;
  L.TextSettings.VertAlign := TTextAlign.Center;

  L.WordWrap := True;
  L.AutoSize := True;

  TmpImg := TImage.Create(Self);
  TmpImg.Parent := CR;
  TmpImg.Align := TAlignLayout.alRight;
  TmpImg.Bitmap.Assign(Image1.Bitmap);
  TmpImg.Width := 50;

  CR.Parent := VSB;
end;

procedure TChat.Button1Click(Sender: TObject);
var
  reply, replyOXML: string;
  Match:TMatch;
  input:String;
  i:integer;
begin
  if Edit1.Text='' then
   Exit;


  input:=Edit1.Text;
  if input.Substring(0,6)='google' then
   begin
     AddBotBrowser('https://www.google.com/#q='+input.Substring(7));
   end
  else
  if input.Substring(0,4)='form' then
   begin
     AddBotForm(input.Substring(5));
     TabControl.ActiveTab := TabItem1;
   end
  else
   begin
    TabControl.ActiveTab := TabItem1;
    LastMessage := input;
    AddUserInput(input);
    Names := EmptyStr;


    Memory.setVar('input',input);
    input:=Trim(ConvertWS(Preprocessor.process(' '+input+' '),true));

    _SentenceSplitter.SetDelimiter(SentenceSplitterChars); {update, if we're still loading}
    _SentenceSplitter.Tokenize(input);

    for i:=0 to _SentenceSplitter._count-1 do begin
      input:=Trim(_SentenceSplitter._tokens[i]);
      Match:=PatternMatcher.MatchInput(input);
      reply := TemplateProcessor.ProcessOXML(Match);
      match.free;
    end;

    AddBotReply(reply);
    //AddLogMessage('Nodes traversed: '+inttostr(PatternMatcher._matchfault));
    //Add('');
    reply:=PreProcessor.process(reply);
    _SentenceSplitter.SetDelimiter(SentenceSplitterChars);
    _SentenceSplitter.Tokenize(reply);

    Memory.setVar('that',_SentenceSplitter.GetLast);
   end;
   Edit1.Text := EmptyStr;

end;

procedure TChat.Button2Click(Sender: TObject);
begin
Edit1.Text := 'form {"id":"10000","name":"myform","description":"","fields":[{"id":"1","name":"mycontrols","controls":[{"id":"1","name":"chocolate","type":"label","text":"Do you like chocolate?"},'+'{"id":"1","name":"chocolateyes","type":"buttonleft","text":"Yes"},{"id":"3","name":"chocolateno","type":"buttonright","text":"No"}]},{"id":"1","name":"mycontrols","controls":[{"id":"1","name":"strawberry","type":"label","text":"Do you like strawberry?"},'+'{"id":"1","name":"strawberryyes","type":"buttonleft","text":"Yes"},{"id":"3","name":"strawberryno","type":"buttonright","text":"No"}]}]}';
button1click(self);
end;

procedure TChat.Edit1KeyUp(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  if Key=vkReturn then
   begin
     Button1Click(Self);
   end;
  if Key=vkUp then
   begin
     Edit1.Text := LastMessage;
   end;
  if Key=vkDown then
   begin
     Edit1.Text := '';
   end;
end;

procedure TChat.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  CanPlay := False;

  BrowserList.Free;

  PatternMatcher.Free;
  TemplateProcessor.Free;

  Memory.Free;
  AIMLLoader.Free;
  BotLoader.Free;
  ElementFactory.Free;
  log.Free;
  preprocessor.Free;

  Application.Terminate;
end;

procedure TChat.FormCreate(Sender: TObject);
begin
  {$IFDEF MSWINDOWS}
  {$ELSE}
 // VKAutoShowMode := TVKAutoShowMode.Always;
  {$ENDIF}

  BrowserList := TStringList.Create;
  BrowserList.OwnsObjects := True;
end;

procedure TChat.FormVirtualKeyboardHidden(Sender: TObject;
  KeyboardVisible: Boolean; const Bounds: TRect);
begin
  {$IF DEFINED(ANDROID)}
  KBRect.Height := Bounds.Height-30;
  {$ENDIF}
  {$IF DEFINED(IOS)}
  KBRect.Height := 0;
  {$ENDIF}
end;

procedure TChat.FormVirtualKeyboardShown(Sender: TObject;
  KeyboardVisible: Boolean; const Bounds: TRect);
begin
  {$IF DEFINED(ANDROID)}
  KBRect.Height := Bounds.Height-30;
  {$ENDIF}
  {$IF DEFINED(IOS)}
  KBRect.Height := Bounds.Height;
  {$ENDIF}
end;

procedure TChat.Timer1Timer(Sender: TObject);
var
ExamplePath: String;
begin
  Timer1.Enabled := False;
  FAppFolder := System.SysUtils.IncludeTrailingPathDelimiter(TPath.GetDocumentsPath) + 'PASCAlice' + TPath.DirectorySeparatorChar;
  ExamplePath := FAppFolder;
  if TDirectory.Exists(ExamplePath)=False then
   begin
    TDirectory.CreateDirectory(ExamplePath);
   end;

  if TDirectory.Exists(ExamplePath)=True then
   begin
    if TFile.Exists(TPath.Combine(ExamplePath,'startup.xml'))=False then
     begin
      StartupXML.Lines.SaveToFile(TPath.Combine(ExamplePath,'startup.xml'));
     end;
   end;


  ExamplePath := System.SysUtils.IncludeTrailingPathDelimiter(TPath.GetDocumentsPath) + 'PASCAlice' + TPath.DirectorySeparatorChar + 'example' + TPath.DirectorySeparatorChar;
  if TDirectory.Exists(ExamplePath)=False then
   begin
    TDirectory.CreateDirectory(ExamplePath);
   end;

    if TFile.Exists(ExamplePath+'forget.aiml')=False then
     begin
      ForgetAIML.Lines.SaveToFile(ExamplePath+'forget.aiml');
     end;
    if TFile.Exists(ExamplePath+'format.aiml')=False then
     begin
      FormatAIML.Lines.SaveToFile(ExamplePath+'format.aiml');
     end;
    if TFile.Exists(ExamplePath+'interface.aiml')=False then
     begin
      InterfaceAIML.Lines.SaveToFile(ExamplePath+'interface.aiml');
     end;
    if TFile.Exists(ExamplePath+'namegame.aiml')=False then
     begin
      NameGameAIML.Lines.SaveToFile(ExamplePath+'namegame.aiml');
     end;
    if TFile.Exists(ExamplePath+'protected.aiml')=False then
     begin
      ProtectedAIML.Lines.SaveToFile(ExamplePath+'protected.aiml');
     end;

    if TFile.Exists(ExamplePath+'Default.aiml')=False then
     begin
      DefaultAIML.Lines.SaveToFile(ExamplePath+'Default.aiml');
     end;
    if TFile.Exists(ExamplePath+'Geography.aiml')=False then
     begin
      GeographyAIML.Lines.SaveToFile(ExamplePath+'Geography.aiml');
     end;
    if TFile.Exists(ExamplePath+'Knowledge.aiml')=False then
     begin
      KnowledgeAIML.Lines.SaveToFile(ExamplePath+'Knowledge.aiml');
     end;
    if TFile.Exists(ExamplePath+'Parts.aiml')=False then
     begin
      PartsAIML.Lines.SaveToFile(ExamplePath+'Parts.aiml');
     end;
    if TFile.Exists(ExamplePath+'Reduce.aiml')=False then
     begin
      ReduceAIML.Lines.SaveToFile(ExamplePath+'Reduce.aiml');
     end;
    if TFile.Exists(ExamplePath+'That.aiml')=False then
     begin
      ThatAIML.Lines.SaveToFile(ExamplePath+'That.aiml');
     end;
    if TFile.Exists(ExamplePath+'update.aiml')=False then
     begin
      UpdateAIML.Lines.SaveToFile(ExamplePath+'update.aiml');
     end;



  Log:=TLog.Create;
  PatternMatcher:=TPatternMatcher.Create;
  TemplateProcessor:=TTemplateProcessor.Create;
  Memory:=Tmemory.create;
  AIMLLoader:=TAIMLLoader.create;
  BotLoader:=TBotLoader.Create;
  Preprocessor:=TSimpleSubstituter.create;
  //ElementFactory:=TElementFactory.Create; {auto create when loading units}
  //TBotloaderThread.Create(false);



  Log.Log('Starting PASCALice FMX v1.5');
  Log.Flush;
  BotLoader.LoadStartup;
  _SentenceSplitter:=TStringTokenizer.Create(SentenceSplitterChars);
  VSB.Visible := True;
  //Chat.InvalidateRect(Chat.Bounds);
  Chat.InvalidateRect(Chat.ClientRect);
  Application.ProcessMessages;

  // uncomment this to access the debugging form on desktop platforms
  //DebugForm.Init;
  //DebugForm.Show;

  CanPlay := True;

  AddBotReply('Hello!');
  PlaySound('Hello!');

end;

initialization
Randomize;


end.
