unit UDebug;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, UPatternMatcher, UVariables,
  FMX.Edit, FMX.Layouts, FMX.ListBox, FMX.ScrollBox, FMX.Memo, FMX.StdCtrls,
  FMX.Controls.Presentation;

type
  TDebugForm = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Memo1: TMemo;
    ListBox1: TListBox;
    edName: TEdit;
    edValue: TEdit;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Edit1: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Timer1: TTimer;
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Init;
  end;

var
  DebugForm: TDebugForm;

implementation

uses UAIMLLoader,UTemplateprocessor, UBotLoader;

{$R *.fmx}

procedure TDebugForm.Init;
begin
  ListBox1.Items:=memory.vars;
  Timer1.Enabled := True;
end;

procedure TDebugForm.Timer1Timer(Sender: TObject);
begin
 Init;
end;

procedure TDebugForm.Button1Click(Sender: TObject);
//var
//  loader:TBotLoader;
begin
//  TBotloaderThread.Create(false);
end;

procedure TDebugForm.Button2Click(Sender: TObject);
var
  M:TMatch;
  i:integer;
begin
Memory.setvar('input',edit1.Text);
M:=PatternMatcher.match;
if m._template='' then
  Memo1.Lines.Add('No match')
else begin
  Memo1.Lines.Add('Pattern:'+M._path);
  for i:=1 to m.count(0) do
    Memo1.Lines.Add('star '+inttostr(i)+ ':'+ M.get(0,i));
  for i:=1 to m.count(1) do
    Memo1.Lines.Add('thatstar '+inttostr(i)+ ':'+ M.get(1,i));
  for i:=1 to m.count(2) do
    Memo1.Lines.Add('topicstar '+inttostr(i)+ ':'+ M.get(2,i));
  Memo1.Lines.Add('------------');
  Memo1.Lines.Add(m._template);
  Memo1.Lines.Add('------------');
  Memo1.Lines.Add(TemplateProcessor.ProcessOXML(m));
  Memo1.Lines.Add('------------');
end;
m.Free;
end;

procedure TDebugForm.Button3Click(Sender: TObject);
var m:THeapStatus;
begin
{$IFDEF WINDOWS}
m:=GetHeapStatus;
Label1.Text:='Free:'+inttostr(m.TotalFree)+'  patterns:'+InttoStr(PatternMatcher._count);
{$ENDIF}
end;

procedure TDebugForm.Button4Click(Sender: TObject);
begin
  Memory.setVar(edName.text,edValue.text);
  ListBox1.Items:=Memory.vars;
end;

procedure TDebugForm.Button5Click(Sender: TObject);
begin
  edValue.Text:=Memory.getVar(edName.Text);
end;

procedure TDebugForm.Button6Click(Sender: TObject);
begin
  Memory.setProp(edName.text,edValue.text);
  ListBox1.Items:=Memory.vars;
end;

procedure TDebugForm.Button7Click(Sender: TObject);
begin
  edValue.Text:=Memory.getProp(edName.Text);
end;

end.
