unit UTemplateProcessor;

interface
uses
   UPatternMatcher,classes,UElementFactory, UUtils, OXmlPDOM, OXmlUtils;
type
  TTXMLNodeHelper = record helper for TXMLNode
    function IsTextElementN : Boolean;
  end;
  TTemplateProcessor=class
    function ProcessOXML(AMatch : TMatch):string;
    class procedure AddProcess(AName : string; var AResult : string;
        AMatch : TMatch; APNode : PXMLNode);
  end;

  function ProcessContentsOXML(AMatch : TMatch; APNode : PXMLNode) : string;
var
  TemplateProcessor:TTemplateProcessor;
const
    arrPTR = ['.', ',', '!', '?', ':', ';'];

implementation
uses
  UVariables,SysUtils;


class procedure TTemplateProcessor.AddProcess(AName : string; var AResult: string;
    AMatch : TMatch; APNode : PXMLNode);
var
    lElement : TTemplateElement;
    lChar : Char;
begin
    if AName='html:br' then
      begin
        AResult := AResult + #13#10;
        Exit;
      end;
    if ElementFactory.get(AName, lElement) then
    begin
        if not AResult.IsEmpty then
        begin
            lChar := AResult[AResult.Length];
            //if lChar in arrPTR then
                AResult := AResult + ' ';
        end;
        AResult := AResult +
            lElement.ProcessOXML(AMatch, APNode);
    end;
end;


function ProcessContentsOXML(AMatch : TMatch; APNode : PXMLNode) : string;
var
    name:string;
    lChildNode: PXMLNode;
begin
    Result := EmptyStr;
    if APNode.IsTextElementN then
        Result := Result + APNode.Text;
    lChildNode := nil;
    while APNode.GetNextChild(lChildNode) do
    begin
         TTemplateProcessor.AddProcess(lChildNode.NodeName, Result, AMatch, lChildNode);
    end;
end;

function TTemplateProcessor.ProcessOXML(AMatch : TMatch): string;
var
    lXML : IXMLDocument;
    lTemp : string;
    Root, lChildNode: PXMLNode;
    SL: TStringList;
begin
  try
    result := EmptyStr;
    lTemp := AMatch._template;
    if lTemp.IsEmpty then
        exit;
    //add virtual root
    lTemp := '<Virtual>' + lTemp + '</Virtual>';
    lXML := CreateXMLDoc;
    if not lXML.LoadFromXML(lTemp) then
        Exit;
    Root := lXML.DocumentElement;
    Root.Normalize;
    lChildNode := nil;
    while Root.GetNextChild(lChildNode) do
    begin
        if lChildNode.NodeType = ntText  then  //????
            Result := Result + lChildNode.Text;
        TTemplateProcessor.AddProcess(lChildNode.NodeName, Result, AMatch, lChildNode);
    end;
    {Parser:=TXMLParser.Create;
    Parser.LoadFromBuffer(MarshaledString(String(match._template)));
    Parser.StartScan;
     while parser.Scan do begin
       case parser.CurPartType of
        ptContent:result:=result+GetElementContents(parser);
        ptEmptyTag,
        ptStartTag,
        ptEndTag:begin
                   if (parser.CurStart<>Parser.DocBuffer) and (parser.CurStart[-1] in CWhitespace) then result:=result+' ';
                   result:=result+ElementFactory.get(parser.CurName).Process(Match,Parser);
                 end;
      end
    end;
    Parser.Free; }
    result := ConvertWs(result,true);
    result := Trim(result);
  except
    on e : Exception do
       raise Exception.Create(e.Message + Names);
  end;
end;

{ TTXMLNodeHelper }

function TTXMLNodeHelper.IsTextElementN: Boolean;
begin
    Result := (Self.NodeType = ntText) or Self.IsTextElement;// or (Self.ChildCount = 0);
end;

end.
