unit uFormWizard;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Graphics, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.StdCtrls,
  FMX.Layouts, FMX.ListBox, JsonDataObjects, FMX.Edit, FMX.WebBrowser,
  System.IniFiles, System.IOUtils, FMX.Surfaces, FMX.ComboEdit, FMX.CalendarEdit,
  FMX.Objects, FMX.DateTimeCtrls, FMX.ExtCtrls, System.UIConsts, UChat,
  duck;

type
  TFormWizard = class(TFrame)
    InfoLB: TListBox;
  private
    { Private declarations }
  public
    { Public declarations }
    function SaveToJson: String;
    procedure LoadFromJson(S: String);
    procedure PopulateForm(S: String);
    procedure SpeedButtonClick(Sender: TObject);
    procedure RangeEditChange(Sender:TObject);
  end;

implementation

{$R *.fmx}

procedure TFormWizard.SpeedButtonClick(Sender: TObject);
begin
TSpeedButton(TSpeedButton(Sender).TagObject).Tag := 0;
  if TSpeedButton(TSpeedButton(Sender).TagObject).IsPressed then
   begin
    TSpeedButton(TSpeedButton(Sender).TagObject).IsPressed := False;
   end;

if (TSpeedButton(Sender).Tag=0) then
 begin
  TSpeedButton(Sender).Tag := 1;
  if (not TSpeedButton(Sender).IsPressed) then
   begin
    TSpeedButton(Sender).IsPressed := True;
   end;
 end
 else
 begin
  TSpeedButton(Sender).Tag := 0;
  if TSpeedButton(Sender).IsPressed then
   begin
    TSpeedButton(Sender).IsPressed := False;
   end;
 end;

TChat(Self.Owner).SpeedButtonClicked(TSpeedButton(Sender));

end;

procedure TFormWizard.RangeEditChange(Sender:TObject);
begin

end;




function TFormWizard.SaveToJson: String;
var
  JObj, ChildJObj: TJsonObject;
begin
  Result := '';
  JObj := TJsonObject.Create;
  try
  Self.duck.all.has('TagString').each(
    procedure(obj: TObject)
    var
    fobj: TFMXObject;
    begin
      fobj := TFMXObject(obj);
      ChildJObj := JObj.A['fields'].AddObject;
      case Trunc(fobj.TagFloat) of
        1: begin
         //ChildJObj[fobj.TagString] := TLabel(fobj).Text;
        end;
        2: begin
         //ChildJObj[fobj.TagString] := TLabel(fobj).Text;
        end;
        3: begin
         //ChildJObj[fobj.TagString] := TLabel(fobj).Text;
        end;
        4: begin
         ChildJObj.S[fobj.TagString] := BoolToStr(TSpeedButton(fobj).IsPressed,True);
        end;
        5: begin
         ChildJObj.S[fobj.TagString] := BoolToStr(TSpeedButton(fobj).IsPressed,True);
        end;
        6: begin
         ChildJObj.S[fobj.TagString] := TEdit(fobj).Text;
        end;
        7: begin
         ChildJObj.S[fobj.TagString] := TComboEdit(fobj).Text;
        end;
        8: begin
         ChildJObj.S[fobj.TagString] := BoolToStr(TCheckBox(fobj).IsChecked,True);
        end;
        9: begin
         ChildJObj.S[fobj.TagString] := TClearingEdit(fobj).Text;
        end;
        10: begin
         ChildJObj.S[fobj.TagString] := TCalendarEdit(fobj).Text;
        end;
        11: begin
         ChildJObj.S[fobj.TagString] := TTimeEdit(fobj).Text;
        end;
        12: begin
         ChildJObj.S[fobj.TagString] := BoolToStr(TSwitch(fobj).IsChecked,True);
        end;
        13: begin
         ChildJObj.S[fobj.TagString] := TPopupBox(fobj).Text;
        end;
        14: begin
         ChildJObj.S[fobj.TagString] := BoolToStr(TSpeedButton(fobj).IsPressed,True);
        end;
        15: begin
         //ChildJObj.S[fobj.TagString] := TLayout(fobj).Name;
        end;
        16: begin
         ChildJObj.S[fobj.TagString] := TLabel(fobj).Text;
        end;
        17: begin
         //ChildJObj.S[fobj.TagString] := TLayout(fobj).Text;
        end;
        18: begin
         //ChildJObj.S[fobj.TagString] := TWebBrowser(fobj).URL;
        end;
        19: begin
         //ChildJObj.S[fobj.TagString] := TSpeedButton(fobj).IsPressed;
        end;
        20: begin
         //ChildJObj.S[fobj.TagString] := TLabel(fobj).Text;
        end;
        21: begin
         ChildJObj.S[fobj.TagString] := BoolToStr(TSpeedButton(fobj).IsPressed,True);
        end;
        22: begin
         //ChildJObj.S[fobj.TagString] := TLabel(fobj).Text;
        end;
        23: begin
         //ChildJObj.S[fobj.TagString] := TSpeedButton(fobj).Text;
        end;
      end;
    end
    );
  Result := JObj.ToJSON({Compact:=}False);
  finally
    JObj.Free;
  end;
end;

function StringToBool(S: String): Boolean;
begin
  if (S='True') OR (S='1') then
   Result := True
  else // if (S='False') OR (S='0') then
   Result := False;
end;

procedure TFormWizard.LoadFromJson(S: String);
var
  JObj, ChildJObj: TJsonObject;
begin
  JObj := TJsonObject.Parse(S) as TJsonObject;
  try
  Self.duck.all.has('TagString').each(
    procedure(obj: TObject)
    var
    fobj: TFMXObject;
    I: Integer;
    begin
      fobj := TFMXObject(obj);
      for I := 0 to JObj['fields'].Count-1 do
       begin
        ChildJObj := JObj['fields'].Items[I];
        if ChildJObj.Contains(fobj.TagString) then
          case Trunc(fobj.TagFloat) of
            1: begin
             //TLabel(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            2: begin
             //TLabel(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            3: begin
             //TLabel(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            4: begin
             TSpeedButton(fobj).IsPressed := StringToBool(ChildJObj.S[fobj.TagString]);
            end;
            5: begin
             TSpeedButton(fobj).IsPressed := StringToBool(ChildJObj.S[fobj.TagString]);
            end;
            6: begin
             TEdit(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            7: begin
             TComboEdit(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            8: begin
             TCheckBox(fobj).IsChecked := StringToBool(ChildJObj.S[fobj.TagString]);
            end;
            9: begin
             TClearingEdit(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            10: begin
             TCalendarEdit(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            11: begin
             TTimeEdit(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            12: begin
             TSwitch(fobj).IsChecked := StringToBool(ChildJObj.S[fobj.TagString]);
            end;
            13: begin
             TPopupBox(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            14: begin
             TSpeedButton(fobj).IsPressed := StringToBool(ChildJObj.S[fobj.TagString]);
            end;
            15: begin
             //ChildJObj.S[fobj.TagString] := TLayout(fobj).Name;
            end;
            16: begin
             TLabel(fobj).Text := ChildJObj.S[fobj.TagString];
            end;
            17: begin
             //ChildJObj.S[fobj.TagString] := TLayout(fobj).Text;
            end;
            18: begin
             //ChildJObj.S[fobj.TagString] := TWebBrowser(fobj).URL;
            end;
            19: begin
             //ChildJObj.S[fobj.TagString] := TSpeedButton(fobj).IsPressed;
            end;
            20: begin
             //ChildJObj.S[fobj.TagString] := TLabel(fobj).Text;
            end;
            21: begin
             TSpeedButton(fobj).IsPressed := StringToBool(ChildJObj.S[fobj.TagString]);
            end;
            22: begin
             //ChildJObj.S[fobj.TagString] := TLabel(fobj).Text;
            end;
          end;
       end;

    end
    );
  finally
    JObj.Free;
  end;
end;

procedure TFormWizard.PopulateForm(S: String);
var
  Obj, ObjField, ObjControl: TJsonObject;
  I,II: Integer;
  LBI: TListBoxItem;
  SL: TStringList;
  III, IV: Integer;
  L: TLabel;
  Layout: TLayout;
  D: TLabel;
  SB1, SB2, SB3, TB: TSpeedButton;
  LO: TFlowLayout;
  Img: TImage;
  E: TEdit;
  H: Extended;
  R: TRectangle;
  CB: TComboEdit;
  CheckB: TCheckBox;
  CE: TClearingEdit;
  CalE: TCalendarEdit;
  TE: TTimeEdit;
  SW: TSwitch;
  PUB: TPopupBox;
  ObjName, RangeTop,RangeBottom: String;
  WB: TWebBrowser;
begin
  Obj := TJsonObject.Parse(S) as TJsonObject;
  InfoLB.BeginUpdate;
  try
    for I := 0 to Obj['fields'].Count-1 do
     begin
      SB1 := nil;
      SB2 := nil;
      SB3 := nil;
      ObjField := Obj['fields'].Items[I];

      LBI := TListBoxItem.Create(InfoLB);
      LBI.Parent := InfoLB;
      LBI.Text := '';
      LBI.Height := 73;
      LBI.TagString := ObjField['id'];

      for II := 0 to ObjField['controls'].Count-1 do
       begin
        ObjControl := ObjField['controls'].Items[II];

        ObjName := ObjControl['name'];

        if (ObjControl['type']='label') then
          begin
              L := TLabel.Create(Self);
              L.Parent := LBI;
              L.Text := ObjControl['text'];
              L.Align := TAlignLayout.alMostLeft;
              L.Margins.Left := 10;
              //L.Font.Style := L.Font.Style+[TFontStyle.fsBold];
              L.StyleLookup := 'listboxitemlabel';
              L.Width := 176;
              L.TagFloat := 1;
              L.TagString := ObjName;
          end;

        if (ObjControl['type']='image') then
          begin
              Img := TImage.Create(Self);
              Img.Parent := LBI;
              Img.Align := TAlignLayout.alRight;
              Img.TagFloat := 2;
              Img.TagString := ObjName;
              //Img.Bitmap.LoadFromFile(obj.CurrentValue.Value);
          end;


        if (ObjControl['type']='desc') OR (ObjControl['type']='leftdesc') then
          begin
              D := TLabel.Create(Self);
              D.Parent := LBI;
              D.Text := ObjControl['text'];
              if (ObjControl['type']='leftdesc') then
              begin
                D.Align := TAlignLayout.alLeft;
                D.Margins.Right := 10;
                D.Width := 182;
              end
              else
              begin
                D.Align := TAlignLayout.alClient;
              end;
              D.TextAlign := TTextAlign.taCenter;
              D.TagString := ObjName;
              D.TagFloat := 3;
          end;

        if (ObjControl['type']='buttonleft') then
          begin
              SB1 := TSpeedButton.Create(Self);
              SB1.Name := 'SB'+IntToStr(I)+'Y'+IntToStr(II);
              SB1.Parent := LBI;
              SB1.Text := ObjControl['text'];
              SB1.Align := TAlignLayout.alRight;
              //SB1.Margins.Right := -49;
              //SB1.TextAlign := TTextAlign.taCenter;
              SB1.StyleLookup := 'segmentedbuttonleft';
              SB1.StaysPressed := True;
              SB1.GroupName := 'SB'+IntToStr(I)+':'+IntToStr(II);
              SB1.OnClick := SpeedButtonClick;
              SB1.TagString := ObjName;
              SB1.TagFloat := 4;
          end;

        if (ObjControl['type']='buttonright') then
          begin
              SB2 := TSpeedButton.Create(Self);
              SB2.Name := 'SB'+IntToStr(I)+'N'+IntToStr(II);
              SB2.Parent := LBI;
              SB2.Text := ObjControl['text'];
              SB2.Align := TAlignLayout.alMostRight;
              SB2.Margins.Right := 50;
              //SB1.TextAlign := TTextAlign.taCenter;
              SB2.StyleLookup := 'segmentedbuttonright';
              SB2.StaysPressed := True;
              SB2.GroupName := 'SB'+IntToStr(I)+':'+IntToStr(II);
              SB2.OnClick := SpeedButtonClick;
              SB2.TagString := ObjName;
              SB2.TagFloat := 5;
          end;

        if (ObjControl['type']='edit') OR (ObjControl['type']='leftedit') OR (ObjControl['type']='rangeedit') then
          begin
              E := TEdit.Create(Self);
              E.Parent := LBI;
              if (ObjControl['type']='rangeedit') then
              begin
                R := TRectangle.Create(Self);
                R.Parent := LBI;
                R.Align := TAlignLayout.alContents;
                R.SendToBack;
                R.Stroke.Kind := TBrushKind.bkNone;
                R.Fill.Color := claRed;
                R.Visible := False;
                E.TagObject := R;

                {aobj2 := obj.A['rangeedit'];
                for III := 0 to aobj2.Length-1 do
                  begin
                    obj2 := aobj2.O[III];
                    for IV := 0 to obj2.Count-1 do
                      begin
                        if (obj2.CurrentKey='text') then
                        begin
                          E.TextPrompt := obj2.CurrentValue.Value;
                        end;
                        if (obj2.CurrentKey='top') then
                        begin
                          RangeTop := obj2.CurrentValue.Value;
                        end;
                        if (obj2.CurrentKey='bottom') then
                        begin
                          RangeBottom := obj2.CurrentValue.Value;
                        end;
                        obj2.Next;
                      end;
                 end;}

                 E.HelpKeyword := RangeTop + '|' + RangeBottom;
                 E.OnChange := RangeEditChange;
              end
              else
              begin
                E.TextPrompt := ObjControl['text'];
              end;
              if (ObjControl['type']='leftedit') then
              begin
                E.Align := TAlignLayout.alLeft;
                E.Margins.Right := 10;
                E.Width := 182;
              end
              else
              begin
                E.Align := TAlignLayout.alClient;
                E.Margins.Right := 50;
                E.Margins.Top := 20;
              end;
              E.Font.Style := [TFontStyle.fsBold];
              E.TextAlign := TTextAlign.taCenter;
              E.TagString := ObjName;
              E.TagFloat := 6;
          end;

        if (ObjControl['type']='comboedit') then
          begin
              SL := TStringList.Create;
              CB := TComboEdit.Create(Self);
              CB.Parent := LBI;

              {aobj2 := obj.A['comboedit'];
              for III := 0 to aobj2.Length-1 do
                begin
                  obj2 := aobj2.O[III];
                  if obj2.Contains('contents') then
                   begin
                     obj3 := obj2.O['contents'];
                      for IV := 0 to obj3.Count-1 do
                        begin
                          SL.Append(obj3.CurrentValue.Value);
                          obj3.Next;
                        end;

                   end;
               end;}



              CB.Items.AddStrings(SL);
              CB.Align := TAlignLayout.alClient;
              CB.Font.Style := [TFontStyle.fsBold];
              CB.TextAlign := TTextAlign.taCenter;
              CB.Margins.Right := 50;
              CB.Margins.Top := 20;
              CB.TagString := ObjName;
              CB.TagFloat := 7;

              SL.Free;
          end;

        if (ObjControl['type']='checkbox') then
          begin
              CheckB := TCheckBox.Create(Self);
              CheckB.Parent := LBI;
              CheckB.Text := ObjControl['text'];
              CheckB.Font.Style := [TFontStyle.fsBold];
              CheckB.Align := TAlignLayout.alRight;
              CheckB.Margins.Right := 50;
              CheckB.TagString := ObjName;
              CheckB.TagFloat := 8;
          end;

        if (ObjControl['type']='clearingedit') then
          begin
              CE := TClearingEdit.Create(Self);
              CE.Parent := LBI;
              CE.TextPrompt := ObjControl['text'];
              CE.Align := TAlignLayout.alClient;
              CE.Font.Style := [TFontStyle.fsBold];
              CE.TextAlign := TTextAlign.taCenter;
              CE.Margins.Right := 50;
              CE.Margins.Top := 20;
              CE.TagString := ObjName;
              CE.TagFloat := 9;
          end;

        if (ObjControl['type']='calendaredit') then
          begin
              CalE := TCalendarEdit.Create(Self);
              CalE.Parent := LBI;
              //CalE.Text := obj.CurrentValue.Value;
              CalE.Align := TAlignLayout.alClient;
              CalE.Font.Style := [TFontStyle.fsBold];
              CalE.TextAlign := TTextAlign.taCenter;
              CalE.Margins.Right := 50;
              CalE.Margins.Top := 20;
              CalE.TagString := ObjName;
              CalE.TagFloat := 10;
          end;

        if (ObjControl['type']='timeedit') then
          begin
              TE := TTimeEdit.Create(Self);
              TE.Parent := LBI;
              //TE.Text := obj.CurrentValue.Value;
              TE.Align := TAlignLayout.alClient;
              TE.Font.Style := [TFontStyle.fsBold];
              TE.TextAlign := TTextAlign.taCenter;
              TE.Margins.Right := 50;
              TE.Margins.Top := 20;
              TE.TagString := ObjName;
              TE.TagFloat := 11;
          end;

        if (ObjControl['type']='switch') then
          begin
              SW := TSwitch.Create(Self);
              SW.Parent := LBI;
              //SW.Text := obj.CurrentValue.Value;
              //SW.Font.Style := [TFontStyle.fsBold];
              SW.Align := TAlignLayout.alRight;
              SW.Margins.Right := 50;
              SW.TagString := ObjName;
              SW.TagFloat := 12;
          end;

        if (ObjControl['type']='popupbox') then
          begin
              SL := TStringList.Create;
              //SL.Text := obj.CurrentValue.Value;
              PUB := TPopupBox.Create(Self);
              PUB.Parent := LBI;

              {aobj2 := obj.A['popupbox'];
              for III := 0 to aobj2.Length-1 do
                begin
                  obj2 := aobj2.O[III];
                  if obj2.Contains('type') then
                   begin
                      if obj2.S['type']='customer' then
                       begin
                        PUB.OnChange := CustomerChange;
                        PUB.OnClick := CustomerClick;
                       end;
                      if obj2.S['type']='lease' then
                       begin
                        PUB.OnChange := LeaseChange;
                        PUB.OnClick := LeaseClick;
                       end;
                      if obj2.S['type']='supervisor' then
                       begin
                        PUB.OnChange := SupervisorChange;
                        PUB.OnClick := SupervisorClick;
                       end;
                      if obj2.S['type']='safety' then
                       begin
                        PUB.OnChange := SafetyChange;
                        PUB.OnClick := SafetyClick;
                       end;
                      if obj2.S['type']='supervisornumber' then
                       begin
                        PUB.OnChange := SupervisorNumberChange;
                        PUB.OnClick := SupervisorNumberClick;
                       end;
                      if obj2.S['type']='safetynumber' then
                       begin
                        PUB.OnChange := SafetyNumberChange;
                        PUB.OnClick := SafetyNumberClick;
                       end;
                   end;

                  if obj2.Contains('contents') then
                   begin
                     obj3 := obj2.O['contents'];

                      for IV := 0 to obj3.Count-1 do
                        begin
                          SL.Append(obj3.CurrentValue.Value);
                          obj3.Next;
                        end;

                   end;

               end;}
              PUB.Items.AddStrings(SL);
              PUB.Align := TAlignLayout.alClient;
              PUB.Font.Style := [TFontStyle.fsBold];
              PUB.TextAlign := TTextAlign.taCenter;
              PUB.Margins.Right := 50;
              PUB.Margins.Top := 20;
              PUB.TagString := ObjName;
              PUB.TagFloat := 13;



              SL.Free;
          end;

        if (ObjControl['type']='toolbutton') then
          begin
              TB := TSpeedButton.Create(Self);
              TB.Name := 'TB'+IntToStr(I)+'N'+IntToStr(II);
              TB.Parent := LBI;
              //TB.Text := obj.CurrentValue.Value;
              TB.Align := TAlignLayout.alMostRight;
              TB.Margins.Right := 50;
              TB.Width := 150;
              //SB3.TextAlign := TTextAlign.taCenter;
              TB.StyleLookup := 'toolbutton';
              //TB.StaysPressed := True;
              //SB3.GroupName := 'SB'+IntToStr(I)+':'+IntToStr(II);
              //TB.OnClick := SpeedButtonClick;

              {obj2 := SO(obj.CurrentValue.ToString);
              for III := 0 to obj2.Count-1 do
                begin
                  if (obj2.CurrentKey='title') then
                    begin
                      TB.Text := obj2.CurrentValue.Value;
                    end;
                  if (obj2.CurrentKey='action') then
                    begin
                      SetupAction(TB,obj2.CurrentValue.Value);
                    end;
                  if (obj2.CurrentKey='settings') then
                    begin
                      //obj2.CurrentValue.Value;
                    end;
                   obj2.Next;
                end;}

              TB.TagString := ObjName;
              TB.TagFloat := 14;
          end;

        if (ObjControl['type']='mapview') then
          begin
              InfoLB.Items.Delete(0);
              H := InfoLB.Height/4;
              InfoLB.Align := TAlignLayout.alBottom;
              InfoLB.Height := H;
              Layout := TLayout.Create(Self);
              Layout.Parent := InfoLB.Parent;
              Layout.Name := 'UIV'+IntToStr(I)+'N'+IntToStr(II);
              Layout.Align := TAlignLayout.alClient;
              Layout.TagString := ObjName;
              Layout.TagFloat := 15;
          end;

        if (ObjControl['type']='preview') OR (ObjControl['type']='webview') then
          begin
              InfoLB.Visible := False;
              InfoLB.Align := TAlignLayout.alNone;
              Layout := TLayout.Create(Self);
              Layout.Parent := InfoLB.Parent;
              Layout.Name := 'UIV'+IntToStr(I)+'N'+IntToStr(II);
              Layout.Align := TAlignLayout.alClient;
              Layout.TagFloat := 17;
              WB := TWebBrowser.Create(Self);
              WB.Name := 'Preview'+IntToStr(I)+'N'+IntToStr(II);
              WB.Parent := Layout;
              WB.Align := TAlignLayout.alClient;
              if (ObjControl['type']='webview') then
               WB.Navigate(ObjControl['text']);
              WB.TagString := ObjName;
              WB.TagFloat := 18;
          end;

        if (ObjControl['type']='additembutton') then
          begin
              TB := TSpeedButton.Create(Self);
              TB.Name := 'TB'+IntToStr(I)+'N'+IntToStr(II);
              TB.Parent := LBI;
              TB.Text := ObjControl['text'];
              TB.Align := TAlignLayout.alMostRight;
              TB.Margins.Right := 50;
              //SB3.TextAlign := TTextAlign.taCenter;
              TB.StyleLookup := 'additembutton';
              //TB.StaysPressed := True;
              //SB3.GroupName := 'SB'+IntToStr(I)+':'+IntToStr(II);
              //TB.OnClick := SpeedButtonClick;
              TB.TagString := ObjName;
              TB.TagFloat := 19;
          end;

        if (ObjControl['type']='signature') then
          begin
              LBI.TagFloat := 20;
          end;

        if (ObjControl['type']='buttonmiddle') then
          begin
              SB3 := TSpeedButton.Create(Self);
              SB3.Name := 'SB'+IntToStr(I)+'N'+IntToStr(II);
              SB3.Parent := LBI;
              SB3.Text := ObjControl['text'];
              SB3.Align := TAlignLayout.alMostRight;
              SB3.Margins.Right := 50;
              //SB1.TextAlign := TTextAlign.taCenter;
              SB3.StyleLookup := 'segmentedbuttonmiddle';
              SB3.StaysPressed := True;
              SB3.GroupName := 'SB'+IntToStr(I)+':'+IntToStr(II);
              SB3.OnClick := SpeedButtonClick;
              SB3.TagString := ObjName;
              SB3.TagFloat := 21;
          end;

        if (ObjControl['type']='header') then
          begin
              D := TLabel.Create(Self);
              D.Parent := LBI;
              D.Text := ObjControl['text'];
              D.Align := TAlignLayout.alClient;
              D.TextAlign := TTextAlign.taCenter;
              D.Font.Style := [TFontStyle.fsBold];
              D.TagString := ObjName;
              D.TagFloat := 22;
          end;

       end;


      if Assigned(SB1) AND Assigned(SB2) then
       begin
        SB1.TagObject := SB2;
        SB2.TagObject := SB1;
       end;

     end;

    LBI := TListBoxItem.Create(InfoLB);
    LBI.Parent := InfoLB;
    LBI.Text := '';
    LBI.Height := 300;

  finally
    Obj.Free;
  end;
  InfoLB.EndUpdate;
end;

end.
