unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.Layouts,
  FMX.Memo, FMX.StdCtrls, REST.Json, XSuperObject, Generics.Tuples;

type
  TPizza = class(TObject)
   public
     FName: string;
     FTopping1: string;
     FTopping2: string;
     FTopping3: string;
   end;

  TForm1 = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    Layout1: TLayout;
    Layout2: TLayout;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Layout3: TLayout;
    Button5: TButton;
    Label3: TLabel;
    Layout4: TLayout;
    Button3: TButton;
    Label4: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    PizzaList: TStringList;
    function GetJsonValue(obj:ISuperObject; Name: String): String;
    procedure LoadJSONToObject(S: String);
    procedure LoadJSONStringLists(S: String);
    procedure LoadJSONXSuperObject(S: String);
    procedure LoadJSONXSuperObjectTuple(S: String);
    procedure ShowList;
    procedure ClearList;
    procedure CreatePizzaList;
    procedure FreePizzaList;
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

function TForm1.GetJsonValue(obj:ISuperObject; Name: String): String;
begin
  Result := '';
  if obj.Contains(Name) then
   Result := obj.S[Name];
end;

procedure TForm1.LoadJSONXSuperObject(S: String);
var
 aobj: ISuperArray;
 obj, obj2: ISuperObject;
 I, II: Integer;
 Pizza: TPizza;
begin

  aobj := SA(S);
  for I := 0 to aobj.Length-1 do
    begin
      obj2 := aobj.O[I];

      Pizza := TPizza.Create;
      Pizza.FName := GetJsonValue(obj2,'Name');
      Pizza.FTopping1 := GetJsonValue(obj2,'Topping1');
      Pizza.FTopping2 := GetJsonValue(obj2,'Topping2');
      Pizza.FTopping3 := GetJsonValue(obj2,'Topping3');
      PizzaList.AddObject(Pizza.FName, Pizza);
    end;
end;

procedure TForm1.LoadJSONStringLists(S: String);
var
 aobj: ISuperArray;
 obj, obj2: ISuperObject;
 I, II: Integer;
 Pizza: TStringList;
begin

  aobj := SA(S);
  for I := 0 to aobj.Length-1 do
    begin
      obj2 := aobj.O[I];

      Pizza := TStringList.Create;
      for II := 0 to obj2.Count-1 do
        begin
          Pizza.Append(obj2.CurrentKey+'='+obj2.CurrentValue.Value);
          obj2.Next;
        end;
      PizzaList.AddObject(Pizza.Values['Name'], Pizza);
    end;
end;

procedure TForm1.LoadJSONXSuperObjectTuple(S: String);
var
 aobj: ISuperArray;
 obj, obj2: ISuperObject;
 I, II: Integer;
 Pizza: TTuple<String, String, String, String>;
begin

  aobj := SA(S);
  for I := 0 to aobj.Length-1 do
    begin
      obj2 := aobj.O[I];

      for II := 0 to obj2.Count-1 do
        begin
          Pizza := TTuple<String, String, String, String>.Create(
          GetJsonValue(obj2,'Name'),
          GetJsonValue(obj2,'Topping1'),
          GetJsonValue(obj2,'Topping2'),
          GetJsonValue(obj2,'Topping3')
          );

          obj2.Next;
        end;
     PizzaList.AddObject(Pizza.Value1, Pizza);
    end;
end;

procedure TForm1.LoadJSONToObject(S: String);
var
 aobj: ISuperArray;
 obj, obj2: ISuperObject;
 I, II: Integer;
 Pizza: TPizza;
begin

  aobj := SA(S);
  for I := 0 to aobj.Length-1 do
    begin
      obj2 := aobj.O[I];

      Pizza := TJson.JsonToObject<TPizza>(obj2.AsJSON);
      PizzaList.AddObject(Pizza.FName, Pizza);
    end;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
ClearList;
LoadJSONXSuperObject(Memo1.Lines.Text);
ShowList;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
ClearList;
LoadJSONToObject(Memo1.Lines.Text);
ShowList;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
I, II: Integer;
SL: TStringList;
begin
ClearList;
LoadJSONStringLists(Memo1.Lines.Text);

Memo2.Lines.Clear;
for I := 0 to PizzaList.Count-1 do
  begin
    SL := TStringList(PizzaList.Objects[I]);
    for II := 0 to SL.Count-1 do
      begin
        Memo2.Lines.Append(SL.Names[II]+': ' + TStrings(PizzaList.Objects[I]).Values[SL.Names[II]]);
      end;
  end;

end;

procedure TForm1.Button5Click(Sender: TObject);
var
I: Integer;
begin
ClearList;
LoadJSONXSuperObjectTuple(Memo1.Lines.Text);

Memo2.Lines.Clear;
for I := 0 to PizzaList.Count-1 do
  begin
    Memo2.Lines.Append('Name: ' + TTuple<String, String, String, String>(PizzaList.Objects[I]).Value1);
    Memo2.Lines.Append('Topping1: ' + TTuple<String, String, String, String>(PizzaList.Objects[I]).Value2);
    Memo2.Lines.Append('Topping2: ' + TTuple<String, String, String, String>(PizzaList.Objects[I]).Value3);
    Memo2.Lines.Append('Topping3: ' + TTuple<String, String, String, String>(PizzaList.Objects[I]).Value4);
  end;

end;

procedure TForm1.Button6Click(Sender: TObject);
var
  I: Integer;
begin
end;

procedure TForm1.ShowList;
var
  I: Integer;
begin
Memo2.Lines.Clear;
for I := 0 to PizzaList.Count-1 do
  begin
    Memo2.Lines.Append('Name: ' + TPizza(PizzaList.Objects[I]).FName);
    Memo2.Lines.Append('Topping1: ' + TPizza(PizzaList.Objects[I]).FTopping1);
    Memo2.Lines.Append('Topping2: ' + TPizza(PizzaList.Objects[I]).FTopping2);
    Memo2.Lines.Append('Topping3: ' + TPizza(PizzaList.Objects[I]).FTopping3);
  end;
end;

procedure TForm1.ClearList;
begin
Memo2.Lines.Clear;
FreePizzaList;
CreatePizzaList;
end;

procedure TForm1.CreatePizzaList;
begin
PizzaList := TStringList.Create;
// automatically free objects attached to list
PizzaList.OwnsObjects := True;
end;

procedure TForm1.FreePizzaList;
begin
 PizzaList.Free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  CreatePizzaList;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 FreePizzaList;
end;

end.
