/*
 * Decompiled with CFR 0.152.
 */
package com.google.example.games.basegameutils;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.example.games.basegameutils.GameHelper;

public abstract class BaseGameActivity
extends FragmentActivity
implements GameHelper.GameHelperListener {
    protected GameHelper mHelper;
    public static final int CLIENT_GAMES = 1;
    public static final int CLIENT_APPSTATE = 4;
    public static final int CLIENT_PLUS = 2;
    public static final int CLIENT_ALL = 3;
    protected int mRequestedClients = 1;
    private static final String TAG = "BaseGameActivity";
    protected boolean mDebugLog = false;

    protected BaseGameActivity() {
    }

    protected BaseGameActivity(int requestedClients) {
        this.setRequestedClients(requestedClients);
    }

    protected void setRequestedClients(int requestedClients) {
        this.mRequestedClients = requestedClients;
    }

    public GameHelper getGameHelper() {
        if (this.mHelper == null) {
            this.mHelper = new GameHelper((Activity)this, this.mRequestedClients);
            this.mHelper.enableDebugLog(this.mDebugLog);
        }
        return this.mHelper;
    }

    protected void onCreate(Bundle b) {
        super.onCreate(b);
        if (this.mHelper == null) {
            this.getGameHelper();
        }
        this.mHelper.setup(this);
    }

    protected void onStart() {
        super.onStart();
        this.mHelper.onStart((Activity)this);
    }

    protected void onStop() {
        super.onStop();
        this.mHelper.onStop();
    }

    protected void onActivityResult(int request, int response, Intent data) {
        super.onActivityResult(request, response, data);
        this.mHelper.onActivityResult(request, response, data);
    }

    protected GoogleApiClient getApiClient() {
        return this.mHelper.getApiClient();
    }

    protected boolean isSignedIn() {
        return this.mHelper.isSignedIn();
    }

    protected void beginUserInitiatedSignIn() {
        this.mHelper.beginUserInitiatedSignIn();
    }

    protected void signOut() {
        this.mHelper.signOut();
    }

    protected void showAlert(String message) {
        this.mHelper.makeSimpleDialog(message).show();
    }

    protected void showAlert(String title, String message) {
        this.mHelper.makeSimpleDialog(title, message).show();
    }

    protected void enableDebugLog(boolean enabled) {
        this.mDebugLog = true;
        if (this.mHelper != null) {
            this.mHelper.enableDebugLog(enabled);
        }
    }

    @Deprecated
    protected void enableDebugLog(boolean enabled, String tag) {
        Log.w((String)TAG, (String)"BaseGameActivity.enabledDebugLog(bool,String) is deprecated. Use enableDebugLog(boolean)");
        this.enableDebugLog(enabled);
    }

    protected String getInvitationId() {
        return this.mHelper.getInvitationId();
    }

    protected void reconnectClient() {
        this.mHelper.reconnectClient();
    }

    protected boolean hasSignInError() {
        return this.mHelper.hasSignInError();
    }

    protected GameHelper.SignInFailureReason getSignInError() {
        return this.mHelper.getSignInError();
    }
}

