/*
 * Decompiled with CFR 0.152.
 */
package com.google.example.games.basegameutils;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.google.android.gms.appstate.AppStateManager;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.plus.Plus;
import com.google.example.games.basegameutils.GameHelperUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class GameHelper
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    static final String TAG = "GameHelper";
    private boolean mSetupDone = false;
    private boolean mConnecting = false;
    boolean mExpectingResolution = false;
    boolean mSignInCancelled = false;
    Activity mActivity = null;
    Context mAppContext = null;
    static final int RC_RESOLVE = 9001;
    static final int RC_UNUSED = 9002;
    GoogleApiClient.Builder mGoogleApiClientBuilder = null;
    Games.GamesOptions mGamesApiOptions = Games.GamesOptions.builder().build();
    Plus.PlusOptions mPlusApiOptions = Plus.PlusOptions.builder().build();
    GoogleApiClient mGoogleApiClient = null;
    public static final int CLIENT_NONE = 0;
    public static final int CLIENT_GAMES = 1;
    public static final int CLIENT_PLUS = 2;
    public static final int CLIENT_APPSTATE = 4;
    public static final int CLIENT_ALL = 3;
    int mRequestedClients = 0;
    boolean mConnectOnStart = true;
    boolean mUserInitiatedSignIn = false;
    ConnectionResult mConnectionResult = null;
    SignInFailureReason mSignInFailureReason = null;
    boolean mShowErrorDialogs = true;
    boolean mDebugLog = false;
    Handler mHandler;
    Invitation mInvitation;
    TurnBasedMatch mTurnBasedMatch;
    ArrayList<GameRequest> mRequests;
    GameHelperListener mListener = null;
    static final int DEFAULT_MAX_SIGN_IN_ATTEMPTS = 3;
    int mMaxAutoSignInAttempts = 3;
    private final String GAMEHELPER_SHARED_PREFS = "GAMEHELPER_SHARED_PREFS";
    private final String KEY_SIGN_IN_CANCELLATIONS = "KEY_SIGN_IN_CANCELLATIONS";

    public GameHelper(Activity activity, int clientsToUse) {
        this.mActivity = activity;
        this.mAppContext = activity.getApplicationContext();
        this.mRequestedClients = clientsToUse;
        this.mHandler = new Handler();
    }

    public void setMaxAutoSignInAttempts(int max) {
        this.mMaxAutoSignInAttempts = max;
    }

    void assertConfigured(String operation) {
        if (!this.mSetupDone) {
            String error = "GameHelper error: Operation attempted without setup: " + operation + ". The setup() method must be called before attempting any other operation.";
            this.logError(error);
            throw new IllegalStateException(error);
        }
    }

    private void doApiOptionsPreCheck() {
        if (this.mGoogleApiClientBuilder != null) {
            String error = "GameHelper: you cannot call set*ApiOptions after the client builder has been created. Call it before calling createApiClientBuilder() or setup().";
            this.logError(error);
            throw new IllegalStateException(error);
        }
    }

    public void setGamesApiOptions(Games.GamesOptions options) {
        this.doApiOptionsPreCheck();
        this.mGamesApiOptions = options;
    }

    public void setPlusApiOptions(Plus.PlusOptions options) {
        this.doApiOptionsPreCheck();
        this.mPlusApiOptions = options;
    }

    public GoogleApiClient.Builder createApiClientBuilder() {
        if (this.mSetupDone) {
            String error = "GameHelper: you called GameHelper.createApiClientBuilder() after calling setup. You can only get a client builder BEFORE performing setup.";
            this.logError(error);
            throw new IllegalStateException(error);
        }
        GoogleApiClient.Builder builder = new GoogleApiClient.Builder((Context)this.mActivity, (GoogleApiClient.ConnectionCallbacks)this, (GoogleApiClient.OnConnectionFailedListener)this);
        if ((this.mRequestedClients & 1) != 0) {
            builder.addApi(Games.API, (Api.ApiOptions.HasOptions)this.mGamesApiOptions);
            builder.addScope(Games.SCOPE_GAMES);
        }
        if ((this.mRequestedClients & 2) != 0) {
            builder.addApi(Plus.API, (Api.ApiOptions.HasOptions)this.mPlusApiOptions);
            builder.addScope(Plus.SCOPE_PLUS_LOGIN);
        }
        if ((this.mRequestedClients & 4) != 0) {
            builder.addApi(AppStateManager.API);
            builder.addScope(AppStateManager.SCOPE_APP_STATE);
        }
        this.mGoogleApiClientBuilder = builder;
        return builder;
    }

    public void setup(GameHelperListener listener) {
        if (this.mSetupDone) {
            String error = "GameHelper: you cannot call GameHelper.setup() more than once!";
            this.logError(error);
            throw new IllegalStateException(error);
        }
        this.mListener = listener;
        this.debugLog("Setup: requested clients: " + this.mRequestedClients);
        if (this.mGoogleApiClientBuilder == null) {
            this.createApiClientBuilder();
        }
        this.mGoogleApiClient = this.mGoogleApiClientBuilder.build();
        this.mGoogleApiClientBuilder = null;
        this.mSetupDone = true;
    }

    public void submitScore(String LBid, long score) {
        Games.Leaderboards.submitScore(this.mGoogleApiClient, LBid, score);
    }

    public Intent GetLeaderboardIntent(String LBid) {
        return Games.Leaderboards.getLeaderboardIntent(this.mGoogleApiClient, LBid);
    }

    public Intent getAchievementsIntent() {
        return Games.Achievements.getAchievementsIntent(this.mGoogleApiClient);
    }

    public void UnlockAchievement(String Aid) {
        Games.Achievements.unlock(this.mGoogleApiClient, Aid);
    }

    public GoogleApiClient getApiClient() {
        if (this.mGoogleApiClient == null) {
            throw new IllegalStateException("No GoogleApiClient. Did you call setup()?");
        }
        return this.mGoogleApiClient;
    }

    public boolean isSignedIn() {
        return this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected();
    }

    public boolean isConnecting() {
        return this.mConnecting;
    }

    public boolean hasSignInError() {
        return this.mSignInFailureReason != null;
    }

    public SignInFailureReason getSignInError() {
        return this.mSignInFailureReason;
    }

    public void setShowErrorDialogs(boolean show) {
        this.mShowErrorDialogs = show;
    }

    public void onStart(Activity act) {
        this.mActivity = act;
        this.mAppContext = act.getApplicationContext();
        this.debugLog("onStart");
        this.assertConfigured("onStart");
        if (this.mConnectOnStart) {
            if (this.mGoogleApiClient.isConnected()) {
                Log.w((String)TAG, (String)"GameHelper: client was already connected on onStart()");
            } else {
                this.debugLog("Connecting client.");
                this.mConnecting = true;
                this.mGoogleApiClient.connect();
            }
        } else {
            this.debugLog("Not attempting to connect becase mConnectOnStart=false");
            this.debugLog("Instead, reporting a sign-in failure.");
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GameHelper.this.notifyListener(false);
                }
            }, 1000L);
        }
    }

    public void onStop() {
        this.debugLog("onStop");
        this.assertConfigured("onStop");
        if (this.mGoogleApiClient.isConnected()) {
            this.debugLog("Disconnecting client due to onStop");
            this.mGoogleApiClient.disconnect();
        } else {
            this.debugLog("Client already disconnected when we got onStop.");
        }
        this.mConnecting = false;
        this.mExpectingResolution = false;
        this.mActivity = null;
    }

    public String getInvitationId() {
        if (!this.mGoogleApiClient.isConnected()) {
            Log.w((String)TAG, (String)"Warning: getInvitationId() should only be called when signed in, that is, after getting onSignInSuceeded()");
        }
        return this.mInvitation == null ? null : this.mInvitation.getInvitationId();
    }

    public Invitation getInvitation() {
        if (!this.mGoogleApiClient.isConnected()) {
            Log.w((String)TAG, (String)"Warning: getInvitation() should only be called when signed in, that is, after getting onSignInSuceeded()");
        }
        return this.mInvitation;
    }

    public boolean hasInvitation() {
        return this.mInvitation != null;
    }

    public boolean hasTurnBasedMatch() {
        return this.mTurnBasedMatch != null;
    }

    public boolean hasRequests() {
        return this.mRequests != null;
    }

    public void clearInvitation() {
        this.mInvitation = null;
    }

    public void clearTurnBasedMatch() {
        this.mTurnBasedMatch = null;
    }

    public void clearRequests() {
        this.mRequests = null;
    }

    public TurnBasedMatch getTurnBasedMatch() {
        if (!this.mGoogleApiClient.isConnected()) {
            Log.w((String)TAG, (String)"Warning: getTurnBasedMatch() should only be called when signed in, that is, after getting onSignInSuceeded()");
        }
        return this.mTurnBasedMatch;
    }

    public ArrayList<GameRequest> getRequests() {
        if (!this.mGoogleApiClient.isConnected()) {
            Log.w((String)TAG, (String)"Warning: getRequests() should only be called when signed in, that is, after getting onSignInSuceeded()");
        }
        return this.mRequests;
    }

    public void enableDebugLog(boolean enabled) {
        this.mDebugLog = enabled;
        if (enabled) {
            this.debugLog("Debug log enabled.");
        }
    }

    @Deprecated
    public void enableDebugLog(boolean enabled, String tag) {
        Log.w((String)TAG, (String)"GameHelper.enableDebugLog(boolean,String) is deprecated. Use GameHelper.enableDebugLog(boolean)");
        this.enableDebugLog(enabled);
    }

    public void signOut() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.debugLog("signOut: was already disconnected, ignoring.");
            return;
        }
        if ((this.mRequestedClients & 2) != 0) {
            this.debugLog("Clearing default account on PlusClient.");
            Plus.AccountApi.clearDefaultAccount(this.mGoogleApiClient);
        }
        if ((this.mRequestedClients & 1) != 0) {
            this.debugLog("Signing out from GamesClient.");
            Games.signOut((GoogleApiClient)this.mGoogleApiClient);
        }
        this.debugLog("Disconnecting client.");
        this.mConnectOnStart = false;
        this.mConnecting = false;
        this.mGoogleApiClient.disconnect();
    }

    public void onActivityResult(int requestCode, int responseCode, Intent intent) {
        this.debugLog("onActivityResult: req=" + (requestCode == 9001 ? "RC_RESOLVE" : String.valueOf(requestCode)) + ", resp=" + GameHelperUtils.activityResponseCodeToString(responseCode));
        if (requestCode != 9001) {
            this.debugLog("onActivityResult: request code not meant for us. Ignoring.");
            return;
        }
        this.mExpectingResolution = false;
        if (!this.mConnecting) {
            this.debugLog("onActivityResult: ignoring because we are not connecting.");
            return;
        }
        if (responseCode == -1) {
            this.debugLog("onAR: Resolution was RESULT_OK, so connecting current client again.");
            this.connect();
        } else if (responseCode == 10001) {
            this.debugLog("onAR: Resolution was RECONNECT_REQUIRED, so reconnecting.");
            this.connect();
        } else if (responseCode == 0) {
            this.debugLog("onAR: Got a cancellation result, so disconnecting.");
            this.mSignInCancelled = true;
            this.mConnectOnStart = false;
            this.mUserInitiatedSignIn = false;
            this.mSignInFailureReason = null;
            this.mConnecting = false;
            this.mGoogleApiClient.disconnect();
            int prevCancellations = this.getSignInCancellations();
            int newCancellations = this.incrementSignInCancellations();
            this.debugLog("onAR: # of cancellations " + prevCancellations + " --> " + newCancellations + ", max " + this.mMaxAutoSignInAttempts);
            this.notifyListener(false);
        } else {
            this.debugLog("onAR: responseCode=" + GameHelperUtils.activityResponseCodeToString(responseCode) + ", so giving up.");
            this.giveUp(new SignInFailureReason(this.mConnectionResult.getErrorCode(), responseCode));
        }
    }

    void notifyListener(boolean success) {
        this.debugLog("Notifying LISTENER of sign-in " + (success ? "SUCCESS" : (this.mSignInFailureReason != null ? "FAILURE (error)" : "FAILURE (no error)")));
        if (this.mListener != null) {
            if (success) {
                this.mListener.onSignInSucceeded();
            } else {
                this.mListener.onSignInFailed();
            }
        }
    }

    public void loadScoreOfLeaderBoard(String LBid) {
        Games.Leaderboards.loadCurrentPlayerLeaderboardScore(this.getApiClient(), LBid, 2, 0).setResultCallback((ResultCallback)new ResultCallback<Leaderboards.LoadPlayerScoreResult>(){

            public void onResult(Leaderboards.LoadPlayerScoreResult scoreResult) {
                if (GameHelper.this.isScoreResultValid(scoreResult)) {
                    long mPoints = scoreResult.getScore().getRawScore();
                    GameHelper.this.mListener.onGetCurrentScore(mPoints);
                } else {
                    GameHelper.this.mListener.onGetCurrentScore(0L);
                }
            }
        });
    }

    private boolean isScoreResultValid(Leaderboards.LoadPlayerScoreResult scoreResult) {
        return scoreResult != null && scoreResult.getStatus().getStatusCode() == 0 && scoreResult.getScore() != null;
    }

    public void beginUserInitiatedSignIn() {
        this.debugLog("beginUserInitiatedSignIn: resetting attempt count.");
        this.resetSignInCancellations();
        this.mSignInCancelled = false;
        this.mConnectOnStart = true;
        if (this.mGoogleApiClient.isConnected()) {
            this.logWarn("beginUserInitiatedSignIn() called when already connected. Calling listener directly to notify of success.");
            this.notifyListener(true);
            return;
        }
        if (this.mConnecting) {
            this.logWarn("beginUserInitiatedSignIn() called when already connecting. Be patient! You can only call this method after you get an onSignInSucceeded() or onSignInFailed() callback. Suggestion: disable the sign-in button on startup and also when it's clicked, and re-enable when you get the callback.");
            return;
        }
        this.debugLog("Starting USER-INITIATED sign-in flow.");
        this.mUserInitiatedSignIn = true;
        if (this.mConnectionResult != null) {
            this.debugLog("beginUserInitiatedSignIn: continuing pending sign-in flow.");
            this.mConnecting = true;
            this.resolveConnectionResult();
        } else {
            this.debugLog("beginUserInitiatedSignIn: starting new sign-in flow.");
            this.mConnecting = true;
            this.connect();
        }
    }

    void connect() {
        if (this.mGoogleApiClient.isConnected()) {
            this.debugLog("Already connected.");
            return;
        }
        this.debugLog("Starting connection.");
        this.mConnecting = true;
        this.mInvitation = null;
        this.mTurnBasedMatch = null;
        this.mGoogleApiClient.connect();
    }

    public void reconnectClient() {
        if (!this.mGoogleApiClient.isConnected()) {
            Log.w((String)TAG, (String)"reconnectClient() called when client is not connected.");
            this.connect();
        } else {
            this.debugLog("Reconnecting client.");
            this.mGoogleApiClient.reconnect();
        }
    }

    public void onConnected(Bundle connectionHint) {
        this.debugLog("onConnected: connected!");
        if (connectionHint != null) {
            this.debugLog("onConnected: connection hint provided. Checking for invite.");
            Invitation inv = (Invitation)connectionHint.getParcelable("invitation");
            if (inv != null && inv.getInvitationId() != null) {
                this.debugLog("onConnected: connection hint has a room invite!");
                this.mInvitation = inv;
                this.debugLog("Invitation ID: " + this.mInvitation.getInvitationId());
            }
            this.mRequests = Games.Requests.getGameRequestsFromBundle(connectionHint);
            if (!this.mRequests.isEmpty()) {
                this.debugLog("onConnected: connection hint has " + this.mRequests.size() + " request(s)");
            }
            this.debugLog("onConnected: connection hint provided. Checking for TBMP game.");
            this.mTurnBasedMatch = (TurnBasedMatch)connectionHint.getParcelable("turn_based_match");
        }
        this.succeedSignIn();
    }

    void succeedSignIn() {
        this.debugLog("succeedSignIn");
        this.mSignInFailureReason = null;
        this.mConnectOnStart = true;
        this.mUserInitiatedSignIn = false;
        this.mConnecting = false;
        this.notifyListener(true);
    }

    int getSignInCancellations() {
        SharedPreferences sp = this.mAppContext.getSharedPreferences("GAMEHELPER_SHARED_PREFS", 0);
        return sp.getInt("KEY_SIGN_IN_CANCELLATIONS", 0);
    }

    int incrementSignInCancellations() {
        int cancellations = this.getSignInCancellations();
        SharedPreferences.Editor editor = this.mAppContext.getSharedPreferences("GAMEHELPER_SHARED_PREFS", 0).edit();
        editor.putInt("KEY_SIGN_IN_CANCELLATIONS", cancellations + 1);
        editor.commit();
        return cancellations + 1;
    }

    void resetSignInCancellations() {
        SharedPreferences.Editor editor = this.mAppContext.getSharedPreferences("GAMEHELPER_SHARED_PREFS", 0).edit();
        editor.putInt("KEY_SIGN_IN_CANCELLATIONS", 0);
        editor.commit();
    }

    public void onConnectionFailed(ConnectionResult result) {
        this.debugLog("onConnectionFailed");
        this.mConnectionResult = result;
        this.debugLog("Connection failure:");
        if (this.mConnectionResult == null) {
            this.debugLog("No result");
        } else {
            this.debugLog("   - resolvable: " + this.mConnectionResult.hasResolution());
            this.debugLog("   - details: " + this.mConnectionResult.toString());
        }
        int cancellations = this.getSignInCancellations();
        boolean shouldResolve = false;
        if (this.mUserInitiatedSignIn) {
            this.debugLog("onConnectionFailed: WILL resolve because user initiated sign-in.");
            shouldResolve = true;
        } else if (this.mSignInCancelled) {
            this.debugLog("onConnectionFailed WILL NOT resolve (user already cancelled once).");
            shouldResolve = false;
        } else if (cancellations < this.mMaxAutoSignInAttempts) {
            this.debugLog("onConnectionFailed: WILL resolve because we have below the max# of attempts, " + cancellations + " < " + this.mMaxAutoSignInAttempts);
            shouldResolve = true;
        } else {
            shouldResolve = false;
            this.debugLog("onConnectionFailed: Will NOT resolve; not user-initiated and max attempts reached: " + cancellations + " >= " + this.mMaxAutoSignInAttempts);
        }
        if (!shouldResolve) {
            this.debugLog("onConnectionFailed: since we won't resolve, failing now.");
            this.mConnectionResult = result;
            this.mConnecting = false;
            this.notifyListener(false);
            return;
        }
        this.debugLog("onConnectionFailed: resolving problem...");
        this.resolveConnectionResult();
    }

    void resolveConnectionResult() {
        if (this.mExpectingResolution) {
            this.debugLog("We're already expecting the result of a previous resolution.");
            return;
        }
        if (this.mActivity == null) {
            this.debugLog("Ignoring attempt to resolve connection result without an active Activity.");
            return;
        }
        this.debugLog("resolveConnectionResult: trying to resolve result: " + this.mConnectionResult);
        if (this.mConnectionResult.hasResolution()) {
            this.debugLog("Result has resolution. Starting it.");
            try {
                this.mExpectingResolution = true;
                this.mConnectionResult.startResolutionForResult(this.mActivity, 9001);
            }
            catch (IntentSender.SendIntentException e) {
                this.debugLog("SendIntentException, so connecting again.");
                this.connect();
            }
            catch (Exception e) {
                this.debugLog("unknown exception.");
            }
        } else {
            this.debugLog("resolveConnectionResult: result has no resolution. Giving up.");
            this.giveUp(new SignInFailureReason(this.mConnectionResult.getErrorCode()));
        }
    }

    public void disconnect() {
        if (this.mGoogleApiClient.isConnected()) {
            this.debugLog("Disconnecting client.");
            this.mGoogleApiClient.disconnect();
        } else {
            Log.w((String)TAG, (String)"disconnect() called when client was already disconnected.");
        }
    }

    void giveUp(SignInFailureReason reason) {
        this.mConnectOnStart = false;
        this.disconnect();
        this.mSignInFailureReason = reason;
        if (reason.mActivityResultCode == 10004) {
            GameHelperUtils.printMisconfiguredDebugInfo(this.mAppContext);
        }
        this.showFailureDialog();
        this.mConnecting = false;
        this.notifyListener(false);
    }

    public void onConnectionSuspended(int cause) {
        this.debugLog("onConnectionSuspended, cause=" + cause);
        this.disconnect();
        this.mSignInFailureReason = null;
        this.debugLog("Making extraordinary call to onSignInFailed callback");
        this.mConnecting = false;
        this.notifyListener(false);
    }

    public void showFailureDialog() {
        if (this.mSignInFailureReason != null) {
            int errorCode = this.mSignInFailureReason.getServiceErrorCode();
            int actResp = this.mSignInFailureReason.getActivityResultCode();
            if (this.mShowErrorDialogs) {
                GameHelper.showFailureDialog(this.mActivity, actResp, errorCode);
            } else {
                this.debugLog("Not showing error dialog because mShowErrorDialogs==false. Error was: " + this.mSignInFailureReason);
            }
        }
    }

    public static void showFailureDialog(Activity activity, int actResp, int errorCode) {
        if (activity == null) {
            Log.e((String)TAG, (String)"*** No Activity. Can't show failure dialog!");
            return;
        }
        Dialog errorDialog = null;
        switch (actResp) {
            case 10004: {
                errorDialog = GameHelper.makeSimpleDialog(activity, GameHelperUtils.getString((Context)activity, 2));
                break;
            }
            case 10002: {
                errorDialog = GameHelper.makeSimpleDialog(activity, GameHelperUtils.getString((Context)activity, 1));
                break;
            }
            case 10003: {
                errorDialog = GameHelper.makeSimpleDialog(activity, GameHelperUtils.getString((Context)activity, 3));
                break;
            }
            default: {
                errorDialog = GooglePlayServicesUtil.getErrorDialog((int)errorCode, (Activity)activity, (int)9002, null);
                if (errorDialog != null) break;
                Log.e((String)TAG, (String)"No standard error dialog available. Making fallback dialog.");
                errorDialog = GameHelper.makeSimpleDialog(activity, String.valueOf(GameHelperUtils.getString((Context)activity, 0)) + " " + GameHelperUtils.errorCodeToString(errorCode));
            }
        }
        errorDialog.show();
    }

    static Dialog makeSimpleDialog(Activity activity, String text) {
        return new AlertDialog.Builder((Context)activity).setMessage((CharSequence)text).setNeutralButton(17039370, null).create();
    }

    static Dialog makeSimpleDialog(Activity activity, String title, String text) {
        return new AlertDialog.Builder((Context)activity).setMessage((CharSequence)text).setTitle((CharSequence)title).setNeutralButton(17039370, null).create();
    }

    public Dialog makeSimpleDialog(String text) {
        if (this.mActivity == null) {
            this.logError("*** makeSimpleDialog failed: no current Activity!");
            return null;
        }
        return GameHelper.makeSimpleDialog(this.mActivity, text);
    }

    public Dialog makeSimpleDialog(String title, String text) {
        if (this.mActivity == null) {
            this.logError("*** makeSimpleDialog failed: no current Activity!");
            return null;
        }
        return GameHelper.makeSimpleDialog(this.mActivity, title, text);
    }

    void debugLog(String message) {
        if (this.mDebugLog) {
            File logFile = new File("sdcard/glog.txt");
            if (!logFile.exists()) {
                try {
                    logFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                BufferedWriter buf = new BufferedWriter(new FileWriter(logFile, true));
                buf.append("\n" + message);
                buf.newLine();
                buf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void logWarn(String message) {
        Log.w((String)TAG, (String)("!!! GameHelper WARNING: " + message));
    }

    void logError(String message) {
        Log.e((String)TAG, (String)("*** GameHelper ERROR: " + message));
    }

    public void setConnectOnStart(boolean connectOnStart) {
        this.debugLog("Forcing mConnectOnStart=" + connectOnStart);
        this.mConnectOnStart = connectOnStart;
    }

    public static interface GameHelperListener {
        public void onSignInFailed();

        public void onSignInSucceeded();

        public void onGetCurrentScore(long var1);
    }

    public static class SignInFailureReason {
        public static final int NO_ACTIVITY_RESULT_CODE = -100;
        int mServiceErrorCode = 0;
        int mActivityResultCode = -100;

        public int getServiceErrorCode() {
            return this.mServiceErrorCode;
        }

        public int getActivityResultCode() {
            return this.mActivityResultCode;
        }

        public SignInFailureReason(int serviceErrorCode, int activityResultCode) {
            this.mServiceErrorCode = serviceErrorCode;
            this.mActivityResultCode = activityResultCode;
        }

        public SignInFailureReason(int serviceErrorCode) {
            this(serviceErrorCode, -100);
        }

        public String toString() {
            return "SignInFailureReason(serviceErrorCode:" + GameHelperUtils.errorCodeToString(this.mServiceErrorCode) + (this.mActivityResultCode == -100 ? ")" : ",activityResultCode:" + GameHelperUtils.activityResponseCodeToString(this.mActivityResultCode) + ")");
        }
    }
}

