/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.aa;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler tO;
    private final Tracker tP;
    private final Context mContext;
    private ExceptionParser tQ;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.tO = originalHandler;
        this.tP = tracker;
        this.tQ = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        aa.C("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.tQ;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.tQ = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread t2, Throwable e2) {
        String string2 = "UncaughtException";
        if (this.tQ != null) {
            String string3 = t2 != null ? t2.getName() : null;
            string2 = this.tQ.getDescription(string3, e2);
        }
        aa.C("Tracking Exception: " + string2);
        this.tP.send(new HitBuilders.ExceptionBuilder().setDescription(string2).setFatal(true).build());
        GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        if (this.tO != null) {
            aa.C("Passing exception to original handler.");
            this.tO.uncaughtException(t2, e2);
        }
    }

    Thread.UncaughtExceptionHandler cD() {
        return this.tO;
    }
}

