/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.in;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long AS;
    private int AT;
    private String At;
    private String Av;
    private String mName;
    private String Ar;
    private int AU;
    private JSONObject AA;

    MediaTrack(JSONObject json) throws JSONException {
        this.b(json);
    }

    MediaTrack(long id2, int type) throws IllegalArgumentException {
        this.clear();
        this.AS = id2;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.AT = type;
    }

    public long getId() {
        return this.AS;
    }

    public int getType() {
        return this.AT;
    }

    public String getContentId() {
        return this.At;
    }

    public void setContentId(String contentId) {
        this.At = contentId;
    }

    public String getContentType() {
        return this.Av;
    }

    public void setContentType(String contentType) {
        this.Av = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.Ar;
    }

    void setLanguage(String language) {
        this.Ar = language;
    }

    public int getSubtype() {
        return this.AU;
    }

    void R(int n2) throws IllegalArgumentException {
        if (n2 <= -1 || n2 > 5) {
            throw new IllegalArgumentException("invalid subtype " + n2);
        }
        if (n2 != 0 && this.AT != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.AU = n2;
    }

    public JSONObject getCustomData() {
        return this.AA;
    }

    void setCustomData(JSONObject customData) {
        this.AA = customData;
    }

    private void clear() {
        this.AS = 0L;
        this.AT = 0;
        this.At = null;
        this.mName = null;
        this.Ar = null;
        this.AU = -1;
        this.AA = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void b(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.AS = jSONObject.getLong("trackId");
        String string2 = jSONObject.getString("type");
        if ("TEXT".equals(string2)) {
            this.AT = 1;
        } else if ("AUDIO".equals(string2)) {
            this.AT = 2;
        } else {
            if (!"VIDEO".equals(string2)) throw new JSONException("invalid type: " + string2);
            this.AT = 3;
        }
        this.At = jSONObject.optString("trackContentId", null);
        this.Av = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.Ar = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string2 = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string2)) {
                this.AU = 1;
            } else if ("CAPTIONS".equals(string2)) {
                this.AU = 2;
            } else if ("DESCRIPTIONS".equals(string2)) {
                this.AU = 3;
            } else if ("CHAPTERS".equals(string2)) {
                this.AU = 4;
            } else {
                if (!"METADATA".equals(string2)) throw new JSONException("invalid subtype: " + string2);
                this.AU = 5;
            }
        } else {
            this.AU = 0;
        }
        this.AA = jSONObject.optJSONObject("customData");
    }

    public JSONObject dZ() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.AS);
            switch (this.AT) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.At != null) {
                jSONObject.put("trackContentId", (Object)this.At);
            }
            if (this.Av != null) {
                jSONObject.put("trackContentType", (Object)this.Av);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.Ar)) {
                jSONObject.put("language", (Object)this.Ar);
            }
            switch (this.AU) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.AA != null) {
                jSONObject.put("customData", (Object)this.AA);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.AA == null != (mediaTrack.AA == null)) {
            return false;
        }
        if (this.AA != null && mediaTrack.AA != null && !in.d(this.AA, mediaTrack.AA)) {
            return false;
        }
        return this.AS == mediaTrack.AS && this.AT == mediaTrack.AT && gi.a(this.At, mediaTrack.At) && gi.a(this.Av, mediaTrack.Av) && gi.a(this.mName, mediaTrack.mName) && gi.a(this.Ar, mediaTrack.Ar) && this.AU == mediaTrack.AU;
    }

    public int hashCode() {
        return hk.hashCode(this.AS, this.AT, this.At, this.Av, this.mName, this.Ar, this.AU, this.AA);
    }

    public static class Builder {
        private final MediaTrack AV;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.AV = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.AV.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.AV.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.AV.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.AV.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.AV.setLanguage(gi.b(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.AV.R(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.AV.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.AV;
        }
    }
}

