/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hk;

public final class Status
implements Result,
SafeParcelable {
    public static final Status En = new Status(0);
    public static final Status Eo = new Status(14);
    public static final Status Ep = new Status(8);
    public static final Status Eq = new Status(15);
    public static final Status Er = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int xM;
    private final int CT;
    private final String Es;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.xM = versionCode;
        this.CT = statusCode;
        this.Es = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(1, statusCode, null, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent eQ() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.Es;
    }

    int getVersionCode() {
        return this.xM;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.CT <= 0;
    }

    public boolean isCanceled() {
        return this.CT == 16;
    }

    public boolean isInterrupted() {
        return this.CT == 14;
    }

    public int getStatusCode() {
        return this.CT;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return hk.hashCode(this.xM, this.CT, this.Es, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.xM == status.xM && this.CT == status.CT && hk.equal(this.Es, status.Es) && hk.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String ex() {
        if (this.Es != null) {
            return this.Es;
        }
        return CommonStatusCodes.getStatusCodeString(this.CT);
    }

    public String toString() {
        return hk.e(this).a("statusCode", this.ex()).a("resolution", this.mPendingIntent).toString();
    }

    @Deprecated
    public ConnectionResult eR() {
        return new ConnectionResult(this.CT, this.mPendingIntent);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

