/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.gw;
import com.google.android.gms.internal.gx;
import com.google.android.gms.internal.hq;
import com.google.android.gms.internal.ip;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object EX = new Object();
    private static HashSet<Uri> EY = new HashSet();
    private static ImageManager EZ;
    private static ImageManager Fa;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService Fb;
    private final b Fc;
    private final gw Fd;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> Fe;
    private final Map<Uri, ImageReceiver> Ff;
    private final Map<Uri, Long> Fg;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (Fa == null) {
                Fa = new ImageManager(context, true);
            }
            return Fa;
        }
        if (EZ == null) {
            EZ = new ImageManager(context, false);
        }
        return EZ;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.Fb = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.Fc = new b(this.mContext);
            if (ip.gf()) {
                this.fc();
            }
        } else {
            this.Fc = null;
        }
        this.Fd = new gw();
        this.Fe = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.Ff = new HashMap<Uri, ImageReceiver>();
        this.Fg = new HashMap<Uri, Long>();
    }

    private void fc() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.Fc));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        a.b b2 = new a.b(imageView, uri);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, int resId) {
        a.b b2 = new a.b(imageView, resId);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        a.b b2 = new a.b(imageView, uri);
        b2.aj(defaultResId);
        this.a(b2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        a.c c2 = new a.c(listener, uri);
        this.a(c2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        a.c c2 = new a.c(listener, uri);
        c2.aj(defaultResId);
        this.a(c2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        gx.ay("ImageManager.loadImage() must be called in the main thread");
        d d2 = new d(a2);
        d2.run();
    }

    private Bitmap a(a.a a2) {
        if (this.Fc == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.Fc.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class b
    extends hq<a.a, Bitmap> {
        public b(Context context) {
            super(b.D(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int D(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && ip.gc() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b Fc;

        public e(b b2) {
            this.Fc = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.Fc.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.Fc.evictAll();
            } else if (level >= 20) {
                this.Fc.trimToSize(this.Fc.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch kK;
        private boolean Fl;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.Fl = bl2;
            this.kK = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            gx.ay("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.mBitmap != null;
            if (ImageManager.this.Fc != null) {
                if (this.Fl) {
                    ImageManager.this.Fc.evictAll();
                    System.gc();
                    this.Fl = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.Fc.put(new a.a(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.Ff.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.kK.countDown();
            Object object = EX;
            synchronized (object) {
                EY.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            ArrayList arrayList = imageReceiver.Fh;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.Fg.put(this.mUri, SystemClock.elapsedRealtime());
                    a2.a(ImageManager.this.mContext, ImageManager.this.Fd, false);
                }
                if (a2 instanceof a.c) continue;
                ImageManager.this.Fe.remove(a2);
            }
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor Fj;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.Fj = parcelFileDescriptor;
        }

        @Override
        public void run() {
            gx.az("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.Fj != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.Fj.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.Fj.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> Fh;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.Fh = new ArrayList();
        }

        public void b(com.google.android.gms.common.images.a a2) {
            gx.ay("ImageReceiver.addImageRequest() must be called in the main thread");
            this.Fh.add(a2);
        }

        public void c(com.google.android.gms.common.images.a a2) {
            gx.ay("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.Fh.remove(a2);
        }

        public void ff() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.Fb.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a Fk;

        public d(com.google.android.gms.common.images.a a2) {
            this.Fk = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            gx.ay("LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.Fe.get(this.Fk));
            if (imageReceiver != null) {
                ImageManager.this.Fe.remove(this.Fk);
                imageReceiver.c(this.Fk);
            }
            a.a a2 = this.Fk.Fm;
            if (a2.uri == null) {
                this.Fk.a(ImageManager.this.mContext, ImageManager.this.Fd, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.Fk.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l2 = (Long)ImageManager.this.Fg.get(a2.uri);
            if (l2 != null) {
                if (SystemClock.elapsedRealtime() - l2 < 3600000L) {
                    this.Fk.a(ImageManager.this.mContext, ImageManager.this.Fd, true);
                    return;
                }
                ImageManager.this.Fg.remove(a2.uri);
            }
            this.Fk.a(ImageManager.this.mContext, ImageManager.this.Fd);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.Ff.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.Ff.put(a2.uri, imageReceiver);
            }
            imageReceiver.b(this.Fk);
            if (!(this.Fk instanceof a.c)) {
                ImageManager.this.Fe.put(this.Fk, imageReceiver);
            }
            Object object = EX;
            synchronized (object) {
                boolean bl2 = EY.contains(a2.uri);
                if (!bl2) {
                    EY.add(a2.uri);
                    imageReceiver.ff();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

