/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDownloadProgressResponse;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.ab;
import com.google.android.gms.drive.internal.aw;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.v;

public class s
extends v
implements DriveFile {
    public s(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.ContentsResult> openContents(GoogleApiClient apiClient, final int mode, final DriveFile.DownloadProgressListener listener) {
        if (mode != 0x10000000 && mode != 0x20000000 && mode != 0x30000000) {
            throw new IllegalArgumentException("Invalid mode provided.");
        }
        return apiClient.a(new d(){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.gp().a(new OpenContentsRequest(s.this.getDriveId(), mode), (ab)new c(this, listener));
            }
        });
    }

    @Override
    public PendingResult<Status> commitAndCloseContents(GoogleApiClient apiClient, final Contents contents) {
        if (contents == null) {
            throw new IllegalArgumentException("Contents must be provided.");
        }
        return apiClient.b(new b(){

            @Override
            protected void a(r r2) throws RemoteException {
                contents.close();
                r2.gp().a(new CloseContentsRequest(contents, true), (ab)new aw(this));
            }
        });
    }

    @Override
    public PendingResult<Status> commitAndCloseContents(GoogleApiClient apiClient, final Contents contents, final MetadataChangeSet changeSet) {
        if (contents == null) {
            throw new IllegalArgumentException("Contents must be provided.");
        }
        return apiClient.b(new a(){

            @Override
            protected void a(r r2) throws RemoteException {
                contents.close();
                r2.gp().a(new CloseContentsAndUpdateMetadataRequest(s.this.Hz, changeSet.gm(), contents, false, null), (ab)new aw(this));
            }
        });
    }

    @Override
    public PendingResult<Status> discardContents(GoogleApiClient apiClient, Contents contents) {
        return Drive.DriveApi.discardContents(apiClient, contents);
    }

    private abstract class a
    extends q<Status> {
        private a() {
        }

        public Status d(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.d(status);
        }
    }

    private abstract class b
    extends q<Status> {
        private b() {
        }

        public Status d(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.d(status);
        }
    }

    private static class c
    extends com.google.android.gms.drive.internal.c {
        private final a.d<DriveApi.ContentsResult> yR;
        private final DriveFile.DownloadProgressListener Je;

        public c(a.d<DriveApi.ContentsResult> d2, DriveFile.DownloadProgressListener downloadProgressListener) {
            this.yR = d2;
            this.Je = downloadProgressListener;
        }

        @Override
        public void a(OnContentsResponse onContentsResponse) throws RemoteException {
            this.yR.a(new p.a(Status.En, onContentsResponse.gt()));
        }

        @Override
        public void a(OnDownloadProgressResponse onDownloadProgressResponse) throws RemoteException {
            if (this.Je != null) {
                this.Je.onProgress(onDownloadProgressResponse.gu(), onDownloadProgressResponse.gv());
            }
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.yR.a(new p.a(status, null));
        }
    }

    private abstract class d
    extends q<DriveApi.ContentsResult> {
        private d() {
        }

        public DriveApi.ContentsResult q(Status status) {
            return new p.a(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.q(status);
        }
    }
}

