/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CreateFileRequest;
import com.google.android.gms.drive.internal.CreateFolderRequest;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.ab;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.s;
import com.google.android.gms.drive.internal.v;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;

public class u
extends v
implements DriveFolder {
    public u(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient apiClient) {
        return this.queryChildren(apiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient apiClient, Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return new p().query(apiClient, builder.build());
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, Contents contents) {
        return this.a(apiClient, changeSet, contents, false, null);
    }

    private PendingResult<DriveFolder.DriveFileResult> a(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, Contents contents, boolean bl2, String string) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (contents == null) {
            throw new IllegalArgumentException("Contents must be provided.");
        }
        if ("application/vnd.google-apps.folder".equals(metadataChangeSet.getMimeType())) {
            throw new IllegalArgumentException("May not create folders (mimetype: application/vnd.google-apps.folder) using this method. Use DriveFolder.createFolder() instead.");
        }
        return this.a(googleApiClient, metadataChangeSet, contents, 0, bl2, string);
    }

    private PendingResult<DriveFolder.DriveFileResult> a(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final Contents contents, final int n2, final boolean bl2, final String string) {
        return googleApiClient.b(new q<DriveFolder.DriveFileResult>(){

            @Override
            protected void a(r r2) throws RemoteException {
                if (contents != null) {
                    contents.close();
                }
                r2.gp().a(new CreateFileRequest(u.this.getDriveId(), metadataChangeSet.gm(), contents, n2, bl2, string), (ab)new a(this));
            }

            public DriveFolder.DriveFileResult s(Status status) {
                return new d(status, null);
            }

            @Override
            public /* synthetic */ Result c(Status status) {
                return this.s(status);
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (changeSet.getMimeType() != null && !changeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return apiClient.b(new c(){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.gp().a(new CreateFolderRequest(u.this.getDriveId(), changeSet.gm()), (ab)new b(this));
            }
        });
    }

    private static class b
    extends com.google.android.gms.drive.internal.c {
        private final a.d<DriveFolder.DriveFolderResult> yR;

        public b(a.d<DriveFolder.DriveFolderResult> d2) {
            this.yR = d2;
        }

        @Override
        public void a(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.yR.a(new e(Status.En, new u(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.yR.a(new e(status, null));
        }
    }

    private static class e
    implements DriveFolder.DriveFolderResult {
        private final Status yz;
        private final DriveFolder Jk;

        public e(Status status, DriveFolder driveFolder) {
            this.yz = status;
            this.Jk = driveFolder;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.Jk;
        }
    }

    private abstract class c
    extends q<DriveFolder.DriveFolderResult> {
        private c() {
        }

        public DriveFolder.DriveFolderResult t(Status status) {
            return new e(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.t(status);
        }
    }

    private static class a
    extends com.google.android.gms.drive.internal.c {
        private final a.d<DriveFolder.DriveFileResult> yR;

        public a(a.d<DriveFolder.DriveFileResult> d2) {
            this.yR = d2;
        }

        @Override
        public void a(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.yR.a(new d(Status.En, new s(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.yR.a(new d(status, null));
        }
    }

    private static class d
    implements DriveFolder.DriveFileResult {
        private final Status yz;
        private final DriveFile Jj;

        public d(Status status, DriveFile driveFile) {
            this.yz = status;
            this.Jj = driveFile;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.Jj;
        }
    }
}

