/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.widget;

import android.content.Context;
import android.database.CursorIndexOutOfBoundsException;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.google.android.gms.common.data.DataBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataBufferAdapter<T>
extends BaseAdapter {
    private final Context mContext;
    private final int LR;
    private int LS;
    private final int LT;
    private final List<DataBuffer<T>> LU;
    private final LayoutInflater LV;
    private boolean LW = true;

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, List<DataBuffer<T>> objects) {
        this.mContext = context;
        this.LR = this.LS = resource;
        this.LT = textViewResourceId;
        this.LU = objects;
        this.LV = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId) {
        this(context, resource, textViewResourceId, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, List<DataBuffer<T>> objects) {
        this(context, resource, 0, objects);
    }

    public DataBufferAdapter(Context context, int resource) {
        this(context, resource, 0, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, DataBuffer<T> ... buffers) {
        this(context, resource, textViewResourceId, Arrays.asList(buffers));
    }

    public DataBufferAdapter(Context context, int resource, DataBuffer<T> ... buffers) {
        this(context, resource, 0, Arrays.asList(buffers));
    }

    public void append(DataBuffer<T> buffer) {
        this.LU.add(buffer);
        if (this.LW) {
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        for (DataBuffer<T> dataBuffer : this.LU) {
            dataBuffer.close();
        }
        this.LU.clear();
        if (this.LW) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.LW = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.LW = notifyOnChange;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getCount() {
        int n2 = 0;
        for (DataBuffer<T> dataBuffer : this.LU) {
            n2 += dataBuffer.getCount();
        }
        return n2;
    }

    public T getItem(int position) throws CursorIndexOutOfBoundsException {
        int n2 = position;
        for (DataBuffer<T> dataBuffer : this.LU) {
            int n3 = dataBuffer.getCount();
            if (n3 <= n2) {
                n2 -= n3;
                continue;
            }
            try {
                return dataBuffer.get(n2);
            }
            catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                throw new CursorIndexOutOfBoundsException(position, this.getCount());
            }
        }
        throw new CursorIndexOutOfBoundsException(position, this.getCount());
    }

    public long getItemId(int position) {
        return position;
    }

    private View a(int n2, View view, ViewGroup viewGroup, int n3) {
        TextView textView;
        View view2 = view == null ? this.LV.inflate(n3, viewGroup, false) : view;
        try {
            textView = this.LT == 0 ? (TextView)view2 : (TextView)view2.findViewById(this.LT);
        }
        catch (ClassCastException classCastException) {
            Log.e((String)"DataBufferAdapter", (String)"You must supply a resource ID for a TextView");
            throw new IllegalStateException("DataBufferAdapter requires the resource ID to be a TextView", classCastException);
        }
        T t2 = this.getItem(n2);
        if (t2 instanceof CharSequence) {
            textView.setText((CharSequence)t2);
        } else {
            textView.setText((CharSequence)t2.toString());
        }
        return view2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.a(position, convertView, parent, this.LR);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.a(position, convertView, parent, this.LS);
    }

    public void setDropDownViewResource(int resource) {
        this.LS = resource;
    }
}

