/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.os.Parcel;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.ExtendedGame;
import com.google.android.gms.games.internal.game.ExtendedGameEntityCreator;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.internal.hk;
import java.util.ArrayList;

public final class ExtendedGameEntity
extends GamesDowngradeableSafeParcel
implements ExtendedGame {
    public static final ExtendedGameEntityCreator CREATOR = new ExtendedGameEntityCreatorCompat();
    private final int xM;
    private final GameEntity Rt;
    private final int Ru;
    private final boolean Rv;
    private final int Rw;
    private final long Rx;
    private final long Ry;
    private final String Rz;
    private final long RA;
    private final String RB;
    private final ArrayList<GameBadgeEntity> RC;
    private final SnapshotMetadataEntity RD;

    public ExtendedGameEntity(ExtendedGame extendedGame) {
        this.xM = 2;
        Game game = extendedGame.getGame();
        this.Rt = game == null ? null : new GameEntity(game);
        this.Ru = extendedGame.hR();
        this.Rv = extendedGame.hS();
        this.Rw = extendedGame.hT();
        this.Rx = extendedGame.hU();
        this.Ry = extendedGame.hV();
        this.Rz = extendedGame.hW();
        this.RA = extendedGame.hX();
        this.RB = extendedGame.hY();
        SnapshotMetadata snapshotMetadata = extendedGame.hZ();
        this.RD = snapshotMetadata == null ? null : new SnapshotMetadataEntity(snapshotMetadata);
        ArrayList<GameBadge> arrayList = extendedGame.hQ();
        int n2 = arrayList.size();
        this.RC = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.RC.add((GameBadgeEntity)arrayList.get(i2).freeze());
        }
    }

    ExtendedGameEntity(int versionCode, GameEntity game, int availability, boolean owned, int achievementUnlockedCount, long lastPlayedServerTimestamp, long priceMicros, String formattedPrice, long fullPriceMicros, String formattedFullPrice, ArrayList<GameBadgeEntity> badges, SnapshotMetadataEntity snapshot) {
        this.xM = versionCode;
        this.Rt = game;
        this.Ru = availability;
        this.Rv = owned;
        this.Rw = achievementUnlockedCount;
        this.Rx = lastPlayedServerTimestamp;
        this.Ry = priceMicros;
        this.Rz = formattedPrice;
        this.RA = fullPriceMicros;
        this.RB = formattedFullPrice;
        this.RC = badges;
        this.RD = snapshot;
    }

    public int getVersionCode() {
        return this.xM;
    }

    public GameEntity ia() {
        return this.Rt;
    }

    @Override
    public ArrayList<GameBadge> hQ() {
        return new ArrayList<GameBadge>(this.RC);
    }

    @Override
    public int hR() {
        return this.Ru;
    }

    @Override
    public boolean hS() {
        return this.Rv;
    }

    @Override
    public int hT() {
        return this.Rw;
    }

    @Override
    public long hU() {
        return this.Rx;
    }

    @Override
    public long hV() {
        return this.Ry;
    }

    @Override
    public String hW() {
        return this.Rz;
    }

    @Override
    public long hX() {
        return this.RA;
    }

    @Override
    public String hY() {
        return this.RB;
    }

    @Override
    public SnapshotMetadata hZ() {
        return this.RD;
    }

    public ExtendedGame ib() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ExtendedGameEntity.a(this);
    }

    static int a(ExtendedGame extendedGame) {
        return hk.hashCode(extendedGame.getGame(), extendedGame.hR(), extendedGame.hS(), extendedGame.hT(), extendedGame.hU(), extendedGame.hV(), extendedGame.hW(), extendedGame.hX(), extendedGame.hY());
    }

    public boolean equals(Object obj) {
        return ExtendedGameEntity.a(this, obj);
    }

    static boolean a(ExtendedGame extendedGame, Object object) {
        if (!(object instanceof ExtendedGame)) {
            return false;
        }
        if (extendedGame == object) {
            return true;
        }
        ExtendedGame extendedGame2 = (ExtendedGame)object;
        return hk.equal(extendedGame2.getGame(), extendedGame.getGame()) && hk.equal(extendedGame2.hR(), extendedGame.hR()) && hk.equal(extendedGame2.hS(), extendedGame.hS()) && hk.equal(extendedGame2.hT(), extendedGame.hT()) && hk.equal(extendedGame2.hU(), extendedGame.hU()) && hk.equal(extendedGame2.hV(), extendedGame.hV()) && hk.equal(extendedGame2.hW(), extendedGame.hW()) && hk.equal(extendedGame2.hX(), extendedGame.hX()) && hk.equal(extendedGame2.hY(), extendedGame.hY());
    }

    public String toString() {
        return ExtendedGameEntity.b(this);
    }

    static String b(ExtendedGame extendedGame) {
        return hk.e(extendedGame).a("Game", extendedGame.getGame()).a("Availability", extendedGame.hR()).a("Owned", extendedGame.hS()).a("AchievementUnlockedCount", extendedGame.hT()).a("LastPlayedServerTimestamp", extendedGame.hU()).a("PriceMicros", extendedGame.hV()).a("FormattedPrice", extendedGame.hW()).a("FullPriceMicros", extendedGame.hX()).a("FormattedFullPrice", extendedGame.hY()).a("Snapshot", extendedGame.hZ()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fr()) {
            ExtendedGameEntityCreator.a(this, dest, flags);
        } else {
            this.Rt.writeToParcel(dest, flags);
            dest.writeInt(this.Ru);
            dest.writeInt(this.Rv ? 1 : 0);
            dest.writeInt(this.Rw);
            dest.writeLong(this.Rx);
            dest.writeLong(this.Ry);
            dest.writeString(this.Rz);
            dest.writeLong(this.RA);
            dest.writeString(this.RB);
            int n2 = this.RC.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.RC.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    @Override
    public /* synthetic */ Game getGame() {
        return this.ia();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.ib();
    }

    static final class ExtendedGameEntityCreatorCompat
    extends ExtendedGameEntityCreator {
        ExtendedGameEntityCreatorCompat() {
        }

        @Override
        public ExtendedGameEntity bg(Parcel parcel) {
            boolean bl2 = ExtendedGameEntity.c(ExtendedGameEntity.fq());
            if (bl2 || ExtendedGameEntity.aA(ExtendedGameEntity.class.getCanonicalName())) {
                return super.bg(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            boolean bl3 = parcel.readInt() == 1;
            int n3 = parcel.readInt();
            long l2 = parcel.readLong();
            long l3 = parcel.readLong();
            String string2 = parcel.readString();
            long l4 = parcel.readLong();
            String string3 = parcel.readString();
            int n4 = parcel.readInt();
            ArrayList<GameBadgeEntity> arrayList = new ArrayList<GameBadgeEntity>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList.add(GameBadgeEntity.CREATOR.bh(parcel));
            }
            SnapshotMetadataEntity snapshotMetadataEntity = null;
            return new ExtendedGameEntity(2, gameEntity, n2, bl3, n3, l2, l3, string2, l4, string3, arrayList, snapshotMetadataEntity);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bg(x0);
        }
    }
}

