/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.games.internal.constants.LeaderboardCollection;
import com.google.android.gms.games.internal.constants.TimeSpan;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.internal.hk;

public final class LeaderboardVariantEntity
implements LeaderboardVariant {
    private final int SH;
    private final int SI;
    private final boolean SJ;
    private final long SK;
    private final String SL;
    private final long SM;
    private final String SN;
    private final String SO;
    private final long SP;
    private final String SQ;
    private final String SR;
    private final String SS;

    public LeaderboardVariantEntity(LeaderboardVariant variant) {
        this.SH = variant.getTimeSpan();
        this.SI = variant.getCollection();
        this.SJ = variant.hasPlayerInfo();
        this.SK = variant.getRawPlayerScore();
        this.SL = variant.getDisplayPlayerScore();
        this.SM = variant.getPlayerRank();
        this.SN = variant.getDisplayPlayerRank();
        this.SO = variant.getPlayerScoreTag();
        this.SP = variant.getNumScores();
        this.SQ = variant.iD();
        this.SR = variant.iE();
        this.SS = variant.iF();
    }

    @Override
    public int getTimeSpan() {
        return this.SH;
    }

    @Override
    public int getCollection() {
        return this.SI;
    }

    @Override
    public boolean hasPlayerInfo() {
        return this.SJ;
    }

    @Override
    public long getRawPlayerScore() {
        return this.SK;
    }

    @Override
    public String getDisplayPlayerScore() {
        return this.SL;
    }

    @Override
    public long getPlayerRank() {
        return this.SM;
    }

    @Override
    public String getDisplayPlayerRank() {
        return this.SN;
    }

    @Override
    public String getPlayerScoreTag() {
        return this.SO;
    }

    @Override
    public long getNumScores() {
        return this.SP;
    }

    @Override
    public String iD() {
        return this.SQ;
    }

    @Override
    public String iE() {
        return this.SR;
    }

    @Override
    public String iF() {
        return this.SS;
    }

    public LeaderboardVariant iG() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardVariantEntity.a(this);
    }

    static int a(LeaderboardVariant leaderboardVariant) {
        return hk.hashCode(leaderboardVariant.getTimeSpan(), leaderboardVariant.getCollection(), leaderboardVariant.hasPlayerInfo(), leaderboardVariant.getRawPlayerScore(), leaderboardVariant.getDisplayPlayerScore(), leaderboardVariant.getPlayerRank(), leaderboardVariant.getDisplayPlayerRank(), leaderboardVariant.getNumScores(), leaderboardVariant.iD(), leaderboardVariant.iF(), leaderboardVariant.iE());
    }

    public boolean equals(Object obj) {
        return LeaderboardVariantEntity.a(this, obj);
    }

    static boolean a(LeaderboardVariant leaderboardVariant, Object object) {
        if (!(object instanceof LeaderboardVariant)) {
            return false;
        }
        if (leaderboardVariant == object) {
            return true;
        }
        LeaderboardVariant leaderboardVariant2 = (LeaderboardVariant)object;
        return hk.equal(leaderboardVariant2.getTimeSpan(), leaderboardVariant.getTimeSpan()) && hk.equal(leaderboardVariant2.getCollection(), leaderboardVariant.getCollection()) && hk.equal(leaderboardVariant2.hasPlayerInfo(), leaderboardVariant.hasPlayerInfo()) && hk.equal(leaderboardVariant2.getRawPlayerScore(), leaderboardVariant.getRawPlayerScore()) && hk.equal(leaderboardVariant2.getDisplayPlayerScore(), leaderboardVariant.getDisplayPlayerScore()) && hk.equal(leaderboardVariant2.getPlayerRank(), leaderboardVariant.getPlayerRank()) && hk.equal(leaderboardVariant2.getDisplayPlayerRank(), leaderboardVariant.getDisplayPlayerRank()) && hk.equal(leaderboardVariant2.getNumScores(), leaderboardVariant.getNumScores()) && hk.equal(leaderboardVariant2.iD(), leaderboardVariant.iD()) && hk.equal(leaderboardVariant2.iF(), leaderboardVariant.iF()) && hk.equal(leaderboardVariant2.iE(), leaderboardVariant.iE());
    }

    public String toString() {
        return LeaderboardVariantEntity.b(this);
    }

    static String b(LeaderboardVariant leaderboardVariant) {
        return hk.e(leaderboardVariant).a("TimeSpan", TimeSpan.cm(leaderboardVariant.getTimeSpan())).a("Collection", LeaderboardCollection.cm(leaderboardVariant.getCollection())).a("RawPlayerScore", leaderboardVariant.hasPlayerInfo() ? Long.valueOf(leaderboardVariant.getRawPlayerScore()) : "none").a("DisplayPlayerScore", leaderboardVariant.hasPlayerInfo() ? leaderboardVariant.getDisplayPlayerScore() : "none").a("PlayerRank", leaderboardVariant.hasPlayerInfo() ? Long.valueOf(leaderboardVariant.getPlayerRank()) : "none").a("DisplayPlayerRank", leaderboardVariant.hasPlayerInfo() ? leaderboardVariant.getDisplayPlayerRank() : "none").a("NumScores", leaderboardVariant.getNumScores()).a("TopPageNextToken", leaderboardVariant.iD()).a("WindowPageNextToken", leaderboardVariant.iF()).a("WindowPagePrevToken", leaderboardVariant.iE()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.iG();
    }
}

