/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer Tv;
    private final TurnBasedMatchBuffer Tw;
    private final TurnBasedMatchBuffer Tx;
    private final TurnBasedMatchBuffer Ty;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.a(matchData, 0);
        this.Tv = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.a(matchData, 1);
        this.Tw = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.a(matchData, 2);
        this.Tx = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.a(matchData, 3);
        this.Ty = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder a(Bundle bundle, int n2) {
        String string2 = TurnBasedMatchTurnStatus.cm(n2);
        if (!bundle.containsKey(string2)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string2);
    }

    public InvitationBuffer getInvitations() {
        return this.Tv;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.Tw;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.Tx;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.Ty;
    }

    public void close() {
        if (this.Tv != null) {
            this.Tv.close();
        }
        if (this.Tw != null) {
            this.Tw.close();
        }
        if (this.Tx != null) {
            this.Tx.close();
        }
        if (this.Ty != null) {
            this.Ty.close();
        }
    }

    public boolean hasData() {
        if (this.Tv != null && this.Tv.getCount() > 0) {
            return true;
        }
        if (this.Tw != null && this.Tw.getCount() > 0) {
            return true;
        }
        if (this.Tx != null && this.Tx.getCount() > 0) {
            return true;
        }
        return this.Ty != null && this.Ty.getCount() > 0;
    }
}

