/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.internal.hm;
import java.util.ArrayList;

public final class TurnBasedMatchConfig {
    private final int SY;
    private final String[] Tn;
    private final Bundle To;
    private final int Tz;

    private TurnBasedMatchConfig(Builder builder) {
        this.SY = builder.SY;
        this.Tz = builder.Tz;
        this.To = builder.To;
        int n2 = builder.Tr.size();
        this.Tn = builder.Tr.toArray(new String[n2]);
    }

    public int getVariant() {
        return this.SY;
    }

    public int iH() {
        return this.Tz;
    }

    public String[] getInvitedPlayerIds() {
        return this.Tn;
    }

    public Bundle getAutoMatchCriteria() {
        return this.To;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int SY = -1;
        ArrayList<String> Tr = new ArrayList();
        Bundle To = null;
        int Tz = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            hm.f(playerId);
            this.Tr.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            hm.f(playerIds);
            this.Tr.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            hm.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.SY = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.To = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfig(this);
        }
    }
}

