/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;
import com.google.android.gms.internal.hk;

public final class MilestoneEntity
implements SafeParcelable,
Milestone {
    public static final MilestoneEntityCreator CREATOR = new MilestoneEntityCreator();
    private final int xM;
    private final String Ot;
    private final long TM;
    private final long TN;
    private final byte[] TO;
    private final int mState;
    private final String Ni;

    public MilestoneEntity(Milestone milestone) {
        this.xM = 4;
        this.Ot = milestone.getMilestoneId();
        this.TM = milestone.getCurrentProgress();
        this.TN = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.Ni = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.TO = null;
        } else {
            this.TO = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.TO, 0, byArray.length);
        }
    }

    MilestoneEntity(int versionCode, String milestoneId, long currentProgress, long targetProgress, byte[] completionBlob, int state, String eventId) {
        this.xM = versionCode;
        this.Ot = milestoneId;
        this.TM = currentProgress;
        this.TN = targetProgress;
        this.TO = completionBlob;
        this.mState = state;
        this.Ni = eventId;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public String getEventId() {
        return this.Ni;
    }

    @Override
    public String getMilestoneId() {
        return this.Ot;
    }

    @Override
    public long getCurrentProgress() {
        return this.TM;
    }

    @Override
    public long getTargetProgress() {
        return this.TN;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.TO;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public Milestone freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.a(this);
    }

    static int a(Milestone milestone) {
        return hk.hashCode(milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId());
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.a(this, obj);
    }

    static boolean a(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return hk.equal(milestone2.getMilestoneId(), milestone.getMilestoneId()) && hk.equal(milestone2.getCurrentProgress(), milestone.getCurrentProgress()) && hk.equal(milestone2.getTargetProgress(), milestone.getTargetProgress()) && hk.equal(milestone2.getState(), milestone.getState()) && hk.equal(milestone2.getEventId(), milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.b(this);
    }

    static String b(Milestone milestone) {
        return hk.e(milestone).a("MilestoneId", milestone.getMilestoneId()).a("CurrentProgress", milestone.getCurrentProgress()).a("TargetProgress", milestone.getTargetProgress()).a("State", milestone.getState()).a("CompletionRewardData", milestone.getCompletionRewardData()).a("EventId", milestone.getEventId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        MilestoneEntityCreator.a(this, out, flags);
    }
}

