/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.al;
import com.google.android.gms.internal.cf;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.eq;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.eu;
import com.google.android.gms.internal.ev;
import com.google.android.gms.internal.ey;
import com.google.android.gms.internal.ez;
import com.google.android.gms.internal.fa;
import com.google.android.gms.internal.fb;
import com.google.android.gms.internal.k;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ex
extends WebView
implements DownloadListener {
    private final ey sA;
    private final a sB;
    private final Object ls = new Object();
    private final k pA;
    private final ev nG;
    private cf sC;
    private al nF;
    private boolean sD;
    private boolean sE;
    private boolean sF;
    private final WindowManager lC;

    public static ex a(Context context, al al2, boolean bl2, boolean bl3, k k2, ev ev2) {
        a a2 = new a(context);
        return new ex(a2, al2, bl2, bl3, k2, ev2);
    }

    private ex(a a2, al al2, boolean bl2, boolean bl3, k k2, ev ev2) {
        super((Context)a2);
        this.sB = a2;
        this.nF = al2;
        this.sD = bl2;
        this.pA = k2;
        this.nG = ev2;
        this.lC = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        eo.a((Context)a2, ev2.sw, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            er.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            eq.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.sA = Build.VERSION.SDK_INT >= 11 ? new fa(this, bl3) : new ey(this, bl3);
        this.setWebViewClient(this.sA);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new fb(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new ez(this));
        }
        this.cg();
    }

    public void bX() {
        if (!this.cb().cj()) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = this.lC.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        int n2 = eo.p(this.getContext());
        float f2 = 160.0f / (float)displayMetrics.densityDpi;
        int n3 = (int)((float)displayMetrics.widthPixels * f2);
        int n4 = (int)((float)(displayMetrics.heightPixels - n2) * f2);
        try {
            JSONObject jSONObject = new JSONObject().put("width", n3).put("height", n4).put("density", (double)displayMetrics.density).put("rotation", display.getRotation());
            this.b("onScreenInfoChanged", jSONObject);
        }
        catch (JSONException jSONException) {
            eu.b("Error occured while obtaining screen information.", jSONException);
        }
    }

    public void a(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = eo.o(map);
        }
        catch (JSONException jSONException) {
            eu.D("Could not convert parameters to JSON.");
            return;
        }
        this.b(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void E(String string2) {
        Object object = this.ls;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                eu.D("The webview is destroyed. Ignoring action.");
            }
        }
    }

    public void a(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:" + string2 + "(");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        this.E(stringBuilder.toString());
    }

    public void b(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        eu.C("Dispatching AFMA event: " + stringBuilder);
        this.E(stringBuilder.toString());
    }

    public void bY() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.nG.sw);
        this.a("onhide", hashMap);
    }

    public void bZ() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.nG.sw);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public cf ca() {
        Object object = this.ls;
        synchronized (object) {
            return this.sC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public al V() {
        Object object = this.ls;
        synchronized (object) {
            return this.nF;
        }
    }

    public ey cb() {
        return this.sA;
    }

    public k cc() {
        return this.pA;
    }

    public ev cd() {
        return this.nG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ce() {
        Object object = this.ls;
        synchronized (object) {
            return this.sD;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            eu.z("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.pA != null) {
            this.pA.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.ls;
        synchronized (object) {
            if (this.isInEditMode() || this.sD) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n6 = Integer.MAX_VALUE;
            if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
                n6 = n3;
            }
            int n7 = Integer.MAX_VALUE;
            if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
                n7 = n5;
            }
            if (this.nF.widthPixels > n6 || this.nF.heightPixels > n7) {
                float f2 = this.sB.getResources().getDisplayMetrics().density;
                eu.D("Not enough space to show ad. Needs " + (int)((float)this.nF.widthPixels / f2) + "x" + (int)((float)this.nF.heightPixels / f2) + " dp, but only has " + (int)((float)n3 / f2) + "x" + (int)((float)n5 / f2) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.nF.widthPixels, this.nF.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, al al2) {
        Object object = this.ls;
        synchronized (object) {
            this.sB.setBaseContext(context);
            this.sC = null;
            this.nF = al2;
            this.sD = false;
            eo.b(this);
            this.loadUrl("about:blank");
            this.sA.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(cf cf2) {
        Object object = this.ls;
        synchronized (object) {
            this.sC = cf2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(al al2) {
        Object object = this.ls;
        synchronized (object) {
            this.nF = al2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void q(boolean bl2) {
        Object object = this.ls;
        synchronized (object) {
            this.sD = bl2;
            this.cg();
        }
    }

    public void setContext(Context context) {
        this.sB.setBaseContext(context);
    }

    public Context cf() {
        return this.sB.cf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cg() {
        Object object = this.ls;
        synchronized (object) {
            if (this.sD || this.nF.mf) {
                if (Build.VERSION.SDK_INT < 14) {
                    eu.z("Disabling hardware acceleration on an overlay.");
                    this.ch();
                } else {
                    eu.z("Enabling hardware acceleration on an overlay.");
                    this.ci();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                eu.z("Disabling hardware acceleration on an AdView.");
                this.ch();
            } else {
                eu.z("Enabling hardware acceleration on an AdView.");
                this.ci();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ch() {
        Object object = this.ls;
        synchronized (object) {
            if (!this.sE && Build.VERSION.SDK_INT >= 11) {
                eq.d((View)this);
            }
            this.sE = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ci() {
        Object object = this.ls;
        synchronized (object) {
            if (this.sE && Build.VERSION.SDK_INT >= 11) {
                eq.e((View)this);
            }
            this.sE = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.ls;
        synchronized (object) {
            super.destroy();
            this.sF = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.ls;
        synchronized (object) {
            return this.sF;
        }
    }

    private static class a
    extends MutableContextWrapper {
        private Activity sG;
        private Context lz;

        public a(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.lz = base.getApplicationContext();
            this.sG = base instanceof Activity ? (Activity)base : null;
            super.setBaseContext(this.lz);
        }

        public void startActivity(Intent intent) {
            if (this.sG != null) {
                this.sG.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.lz.startActivity(intent);
            }
        }

        public Context cf() {
            return this.sG;
        }
    }
}

