/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.internal.gg;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.gq;
import com.google.android.gms.internal.gr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class go
extends gg {
    private static final String NAMESPACE = gi.al("com.google.cast.media");
    private static final long Cp = TimeUnit.HOURS.toMillis(24L);
    private static final long Cq = TimeUnit.HOURS.toMillis(24L);
    private static final long Cr = TimeUnit.HOURS.toMillis(24L);
    private static final long Cs = TimeUnit.SECONDS.toMillis(1L);
    private long Ct;
    private MediaStatus Cu;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final gr Cv;
    private final gr Cw;
    private final gr Cx;
    private final gr Cy;
    private final gr Cz;
    private final gr CA;
    private final gr CB;
    private final gr CC;
    private final gr CD;
    private final gr CE;
    private final List<gr> CF;
    private final Runnable CG = new a();
    private boolean CH;

    public go() {
        this(null);
    }

    public go(String string2) {
        super(NAMESPACE, "MediaControlChannel", string2);
        this.CF = new ArrayList<gr>();
        this.Cv = new gr(Cq);
        this.CF.add(this.Cv);
        this.Cw = new gr(Cp);
        this.CF.add(this.Cw);
        this.Cx = new gr(Cp);
        this.CF.add(this.Cx);
        this.Cy = new gr(Cp);
        this.CF.add(this.Cy);
        this.Cz = new gr(Cr);
        this.CF.add(this.Cz);
        this.CA = new gr(Cp);
        this.CF.add(this.CA);
        this.CB = new gr(Cp);
        this.CF.add(this.CB);
        this.CC = new gr(Cp);
        this.CF.add(this.CC);
        this.CD = new gr(Cp);
        this.CF.add(this.CD);
        this.CE = new gr(Cp);
        this.CF.add(this.CE);
        this.et();
    }

    public long a(gq gq2, MediaInfo mediaInfo, boolean bl2, long l2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.ed();
        this.Cv.a(l3, gq2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.dZ());
            jSONObject2.put("autoplay", bl2);
            jSONObject2.put("currentTime", gi.o(l2));
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(gq gq2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.ed();
        this.Cw.a(l2, gq2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.ea());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long b(gq gq2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.ed();
        this.Cy.a(l2, gq2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.ea());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long c(gq gq2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.ed();
        this.Cx.a(l2, gq2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.ea());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(gq gq2, long l2, int n2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.ed();
        this.Cz.a(l3, gq2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.ea());
            jSONObject2.put("currentTime", gi.o(l2));
            if (n2 == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n2 == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(gq gq2, double d2, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.ed();
        this.CA.a(l2, gq2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.ea());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(gq gq2, boolean bl2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.ed();
        this.CB.a(l2, gq2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.ea());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(gq gq2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.ed();
        this.CC.a(l2, gq2);
        this.z(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.Cu != null) {
                jSONObject.put("mediaSessionId", this.Cu.ea());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long a(gq gq2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.ed();
        this.CD.a(l2, gq2);
        this.z(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.ea());
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                jSONArray.put(i2, lArray[i2]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long a(gq gq2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.ed();
        this.CE.a(l2, gq2);
        this.z(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.dZ());
            }
            jSONObject.put("mediaSessionId", this.ea());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.Ct == 0L) {
            return 0L;
        }
        double d2 = this.Cu.getPlaybackRate();
        long l2 = this.Cu.getStreamPosition();
        int n2 = this.Cu.getPlayerState();
        if (d2 == 0.0 || n2 != 2) {
            return l2;
        }
        long l3 = SystemClock.elapsedRealtime() - this.Ct;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l2;
        }
        long l4 = l2 + (long)((double)l3 * d2);
        long l5 = mediaInfo.getStreamDuration();
        if (l4 > l5) {
            l4 = l5;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.Cu;
    }

    public MediaInfo getMediaInfo() {
        return this.Cu == null ? null : this.Cu.getMediaInfo();
    }

    @Override
    public final void ai(String string2) {
        this.BD.b("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l2 = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.a(l2, jSONArray.getJSONObject(0));
                } else {
                    this.Cu = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.CC.c(l2, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.BD.d("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (gr gr2 : this.CF) {
                    gr2.b(l2, 1, jSONObject2);
                }
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.Cv.b(l2, 1, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.Cv.b(l2, 2, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.BD.d("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (gr gr3 : this.CF) {
                    gr3.b(l2, 1, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.BD.d("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    @Override
    public void a(long l2, int n2) {
        for (gr gr2 : this.CF) {
            gr2.c(l2, n2);
        }
    }

    private void a(long l2, JSONObject jSONObject) throws JSONException {
        boolean bl2 = this.Cv.p(l2);
        boolean bl3 = this.Cz.ev() && !this.Cz.p(l2);
        boolean bl4 = this.CA.ev() && !this.CA.p(l2) || this.CB.ev() && !this.CB.p(l2);
        int n2 = 0;
        if (bl3) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 1;
        }
        int n3 = 0;
        if (bl2 || this.Cu == null) {
            this.Cu = new MediaStatus(jSONObject);
            this.Ct = SystemClock.elapsedRealtime();
            n3 = 7;
        } else {
            n3 = this.Cu.a(jSONObject, n2);
        }
        if ((n3 & 1) != 0) {
            this.Ct = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 2) != 0) {
            this.Ct = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 4) != 0) {
            this.onMetadataUpdated();
        }
        for (gr gr2 : this.CF) {
            gr2.c(l2, 0);
        }
    }

    public long ea() throws IllegalStateException {
        if (this.Cu == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.Cu.ea();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    private void et() {
        this.z(false);
        this.Ct = 0L;
        this.Cu = null;
        this.Cv.clear();
        this.Cz.clear();
        this.CA.clear();
    }

    @Override
    public void ee() {
        this.et();
    }

    private void z(boolean bl2) {
        if (this.CH != bl2) {
            this.CH = bl2;
            if (bl2) {
                this.mHandler.postDelayed(this.CG, Cs);
            } else {
                this.mHandler.removeCallbacks(this.CG);
            }
        }
    }

    private class a
    implements Runnable {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object2;
            go.this.CH = false;
            long l2 = SystemClock.elapsedRealtime();
            for (Object object2 : go.this.CF) {
                ((gr)object2).d(l2, 3);
            }
            boolean bl2 = false;
            object2 = gr.CN;
            synchronized (object2) {
                for (gr gr2 : go.this.CF) {
                    if (!gr2.ev()) continue;
                    bl2 = true;
                }
            }
            go.this.z(bl2);
        }
    }
}

