/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.ip;

public final class gt
extends Drawable
implements Drawable.Callback {
    private int Fv = 0;
    private long Fw;
    private int Fx;
    private int Fy;
    private int Fz = 255;
    private int FA;
    private int FB = 0;
    private boolean Fp = true;
    private boolean FC;
    private b FD;
    private Drawable FE;
    private Drawable FF;
    private boolean FG;
    private boolean FH;
    private boolean FI;
    private int FJ;

    public gt(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = a.FK;
        }
        this.FE = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.FD.FN |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = a.FK;
        }
        this.FF = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.FD.FN |= drawable3.getChangingConfigurations();
    }

    gt(b b2) {
        this.FD = new b(b2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (ip.gc() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (ip.gc() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (ip.gc() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.FD.FM | this.FD.FN;
    }

    public void setAlpha(int alpha) {
        if (this.FB == this.Fz) {
            this.FB = alpha;
        }
        this.Fz = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf2) {
        this.FE.setColorFilter(cf2);
        this.FF.setColorFilter(cf2);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.FE.getIntrinsicWidth(), this.FF.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.FE.getIntrinsicHeight(), this.FF.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.FE.setBounds(bounds);
        this.FF.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.FD.FM = this.getChangingConfigurations();
            return this.FD;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.FI) {
            this.FJ = Drawable.resolveOpacity((int)this.FE.getOpacity(), (int)this.FF.getOpacity());
            this.FI = true;
        }
        return this.FJ;
    }

    public boolean canConstantState() {
        if (!this.FG) {
            this.FH = this.FE.getConstantState() != null && this.FF.getConstantState() != null;
            this.FG = true;
        }
        return this.FH;
    }

    public Drawable mutate() {
        if (!this.FC && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.FE.mutate();
            this.FF.mutate();
            this.FC = true;
        }
        return this;
    }

    public Drawable fg() {
        return this.FF;
    }

    public void startTransition(int durationMillis) {
        this.Fx = 0;
        this.Fy = this.Fz;
        this.FB = 0;
        this.FA = durationMillis;
        this.Fv = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl2 = true;
        switch (this.Fv) {
            case 1: {
                this.Fw = SystemClock.uptimeMillis();
                bl2 = false;
                this.Fv = 2;
                break;
            }
            case 2: {
                if (this.Fw < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.Fw) / (float)this.FA;
                boolean bl3 = bl2 = f2 >= 1.0f;
                if (bl2) {
                    this.Fv = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.FB = (int)((float)this.Fx + (float)(this.Fy - this.Fx) * f2);
            }
        }
        int n2 = this.FB;
        boolean bl4 = this.Fp;
        Drawable drawable2 = this.FE;
        Drawable drawable3 = this.FF;
        if (bl2) {
            if (!bl4 || n2 == 0) {
                drawable2.draw(canvas);
            }
            if (n2 == this.Fz) {
                drawable3.setAlpha(this.Fz);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl4) {
            drawable2.setAlpha(this.Fz - n2);
        }
        drawable2.draw(canvas);
        if (bl4) {
            drawable2.setAlpha(this.Fz);
        }
        if (n2 > 0) {
            drawable3.setAlpha(n2);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.Fz);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.gt$a
    extends Drawable {
        private static final com.google.android.gms.internal.gt$a FK = new com.google.android.gms.internal.gt$a();
        private static final a FL = new a();

        private com.google.android.gms.internal.gt$a() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf2) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return FL;
        }

        private static final class a
        extends Drawable.ConstantState {
            private a() {
            }

            public Drawable newDrawable() {
                return FK;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class b
    extends Drawable.ConstantState {
        int FM;
        int FN;

        b(b b2) {
            if (b2 != null) {
                this.FM = b2.FM;
                this.FN = b2.FN;
            }
        }

        public Drawable newDrawable() {
            return new gt(this);
        }

        public int getChangingConfigurations() {
            return this.FM;
        }
    }
}

