/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class hq<K, V> {
    private final LinkedHashMap<K, V> GM;
    private int size;
    private int GN;
    private int GO;
    private int GP;
    private int GQ;
    private int GR;
    private int GS;

    public hq(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.GN = n2;
        this.GM = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        hq<K, V> hq2 = this;
        synchronized (hq2) {
            object = this.GM.get(key);
            if (object != null) {
                ++this.GR;
                return object;
            }
            ++this.GS;
        }
        hq2 = this.create(key);
        if (hq2 == null) {
            return null;
        }
        hq hq3 = this;
        synchronized (hq3) {
            ++this.GP;
            object = this.GM.put(key, hq2);
            if (object != null) {
                this.GM.put(key, object);
            } else {
                this.size += this.c(key, hq2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, hq2, object);
            return object;
        }
        this.trimToSize(this.GN);
        return (V)hq2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        hq hq2 = this;
        synchronized (hq2) {
            ++this.GO;
            this.size += this.c(key, value);
            v2 = this.GM.put(key, value);
            if (v2 != null) {
                this.size -= this.c(key, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, key, v2, value);
        }
        this.trimToSize(this.GN);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v2;
            K k2;
            hq hq2 = this;
            synchronized (hq2) {
                if (this.size < 0 || this.GM.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.GM.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.GM.entrySet().iterator().next();
                k2 = entry.getKey();
                v2 = entry.getValue();
                this.GM.remove(k2);
                this.size -= this.c(k2, v2);
                ++this.GQ;
            }
            this.entryRemoved(true, k2, v2, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int c(K k2, V v2) {
        int n2 = this.sizeOf(k2, v2);
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + k2 + "=" + v2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n2 = this.GR + this.GS;
        int n3 = n2 != 0 ? 100 * this.GR / n2 : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.GN, this.GR, this.GS, n3);
    }
}

