unit BaseGameUtils;

{Java bridge class imported by hand by Pham Dinh Hai for BaseGameUtils a Google Play game services wrapper(https://github.com/playgameservices/android-basic-samples) with some modification of BaseGameUtils library.
	email:deuxvn@gmail.com
	website:http://deuxsoftware.com
 You are free to use the source code (even for commercial purposes) as long as you provide a link to this website(http://deuxsoftware.com) from app OR credit us with
}
interface
uses
  Androidapi.JNIBridge,
  Androidapi.JNI.JavaTypes,
  Androidapi.JNI.GraphicsContentViewText,
  Androidapi.JNI.App,
  Androidapi.JNI.Os,
  FMX.Platform.Android;
const
    LeaderBoardID = 'Your leaderboard ID';

type
  JGameHelper = interface;
  JGameHelper_GameHelperListener = interface;
  JGoogleApiClient = interface;

  JGameHelperClass = interface(JObjectClass)
    ['{19DD0820-41D8-44FD-B05D-2C7D61B3634D}']
    {Property methods}
    function _GetCLIENT_ALL: Integer; cdecl;
    function _GetCLIENT_GAMES: Integer; cdecl;
    {Methods}
    function init(activity: JActivity;ClientToUse:Integer): JGameHelper; cdecl; overload;
    {Properties}
    property CLIENT_ALL: Integer read _GetCLIENT_ALL;
    property CLIENT_GAMES: Integer read _GetCLIENT_GAMES;
  end;

  [JavaSignature('com/google/example/games/basegameutils/GameHelper')]
  JGameHelper = interface(JObject)
  ['{DC334E08-C537-4900-8333-4E882BCEA010}']
    {Methods}
    procedure setup(listener:JGameHelper_GameHelperListener);cdecl;
    procedure onStart(ac:JActivity);cdecl;
    procedure onStop();cdecl;
    function isSignedIn:boolean;cdecl;
    function getApiClient:JGoogleApiClient;
    procedure submitScore(LBid:JString;score:int64);cdecl;
    function GetLeaderboardIntent(LBid:JString):Jintent;
    function getAchievementsIntent():Jintent;
    procedure UnlockAchievement(Aid:JString);cdecl;
    procedure loadScoreOfLeaderBoard(LBid:JString);cdecl;
    procedure enableDebugLog(enabled:boolean);cdecl;
    procedure onActivityResult(requestCode:integer; resultCode:integer; data:JIntent);cdecl;
  end;
  TJGameHelper = class(TJavaGenericImport<JGameHelperClass, JGameHelper>) end;

  JGameHelper_GameHelperListenerClass = interface(IJavaClass)
    ['{DD2508EF-AE0D-4F40-B07F-0DF1657260ED}']
  end;

  [JavaSignature('com/google/example/games/basegameutils/GameHelper$GameHelperListener')]
  JGameHelper_GameHelperListener = interface(IJavaInstance)
  ['{5F4376BE-0B0B-4B1F-98CC-64F983DE8306}']
    {Methods}
    procedure onSignInFailed();cdecl;
    procedure onSignInSucceeded();cdecl;
    PROCEDURE onGetCurrentScore(score:int64);cdecl;
//    procedure onFacebookError(e:JFacebookError);cdecl;
//    procedure onError(e:JDialogError);cdecl;
  end;
  TJGameHelper_GameHelperListener = class(TJavaGenericImport<JGameHelper_GameHelperListenerClass, JGameHelper_GameHelperListener>) end;

  TGameHelperListener = class(TJavaLocal, JGameHelper_GameHelperListener)
  public
    constructor Create();
//    destructor Destroy; override;
    procedure onSignInFailed();cdecl;
    procedure onSignInSucceeded;cdecl;
    PROCEDURE onGetCurrentScore(score:int64);cdecl;
  end;

  JGoogleApiClientClass = interface(JObjectClass)
    ['{DAFF51BF-5277-411F-8A9A-FE601A81ECE1}']
  end;

  [JavaSignature('com/google/android/gms/common/api/GoogleApiClient')]
  JGoogleApiClient = interface(JObject)
  ['{7FA1DA6A-B725-4DE2-BDCE-27C4ED1FEAA4}']
    {Methods}
    function isConnected:boolean;cdecl;
  end;
  TJGoogleApiClient = class(TJavaGenericImport<JGoogleApiClientClass, JGoogleApiClient>) end;


var
 mHelper:JGameHelper;
 Listener:JGameHelper_GameHelperListener;
 isSignedIn:boolean;
 procedure InitGameHelper;
 procedure SubmitScore(score:int64);
 procedure LoadLeaderBoard;
 procedure UnlockAchievements(score:int64);
 procedure LoadAchievementsBoard;

implementation

uses
  FMX.Helpers.Android,AndroidApi.Helpers;

procedure InitGameHelper;
begin
  isSignedIn:=false;

    CallInUiThread(procedure
    begin
      mHelper:=TJGameHelper.JavaClass.init(SharedActivity,TJGameHelper.JavaClass.CLIENT_GAMES);
      end);
    Listener:=TGameHelperListener.Create;
    CallInUiThread(procedure
    begin
      mHelper.setup(Listener)
    end);
    CallInUiThread(procedure
    begin
      mHelper.onStart(SharedActivity)
    end);

end;

procedure SubmitScore(score:int64);
begin
  if isSignedIn and(score>0)then begin
    CallInUiThread(procedure
    begin
      mHelper.submitScore(StringToJString(LeaderBoardID),score);
    end);
  end;
end;

procedure UnlockAchievements(score:int64);
begin
//example of using unlock achievements based on score
  if isSignedIn then begin
     if score>=5 then CallInUiThread(procedure begin mHelper.UnlockAchievement(StringToJString('Your achievement id'))end);
     if score>=10 then CallInUiThread(procedure begin mHelper.UnlockAchievement(StringToJString('Your achievement id'))end);
     if score>=20 then CallInUiThread(procedure begin mHelper.UnlockAchievement(StringToJString('Your achievement id'))end);
     if score>=50 then CallInUiThread(procedure begin mHelper.UnlockAchievement(StringToJString('Your achievement id'))end);
     if score>=100 then CallInUiThread(procedure begin mHelper.UnlockAchievement(StringToJString('Your achievement id'))end);
  end;
end;
procedure LoadLeaderBoard;
begin
  if isSignedIn then begin
      SharedActivity.StartActivityForResult(mHelper.GetLeaderboardIntent(StringToJString(LeaderBoardID)),0);
  end;
end;
procedure LoadAchievementsBoard;
begin
  if isSignedIn then begin
      SharedActivity.StartActivityForResult(mHelper.getAchievementsIntent,0);
  end;
end;
constructor TGameHelperListener.Create();
begin
  inherited Create;
end;

procedure TGameHelperListener.onGetCurrentScore(score: int64);
var
  editor:JSharedPreferences_Editor;
begin
  //received score from game service, save to local or do what you want
end;

procedure TGameHelperListener.onSignInFailed();
begin
//signed in failed do what you want here
end;

procedure TGameHelperListener.onSignInSucceeded;
var
  editor:JSharedPreferences_Editor;
begin
//connected to Game services do what you want here
isSignedIn:=true;
mHelper.loadScoreOfLeaderBoard(StringToJString(LeaderBoardId));
end;

procedure RegisterTypes;
begin
  TRegTypes.RegisterType('Androidapi.JNI.BaseGameUtils.JGameHelper', TypeInfo(Androidapi.JNI.BaseGameUtils.JGameHelper));
  TRegTypes.RegisterType('Androidapi.JNI.BaseGameUtils.JGameHelper_GameHelperListener', TypeInfo(Androidapi.JNI.BaseGameUtils.JGameHelper_GameHelperListener));
  TRegTypes.RegisterType('Androidapi.JNI.BaseGameUtils.JGoogleApiClient', TypeInfo(Androidapi.JNI.BaseGameUtils.JGoogleApiClient));
end;

initialization
  RegisterTypes;
end.