unit MainFrm;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, System.Sensors, System.Sensors.Components, FMX.Controls.Presentation, FMX.ScrollBox,
  FMX.Memo, FMX.Platform;

type
  TfrmMain = class(TForm)
    LocationSensor1: TLocationSensor;
    Memo1: TMemo;
    procedure LocationSensor1LocationChanged(Sender: TObject; const [Ref] OldLocation, NewLocation: TLocationCoord2D);
  private
    FIsInBackground: Boolean;
    function AppEventHandler(AAppEvent: TApplicationEvent; AContext: TObject): Boolean;
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.fmx}

{ TfrmMain }

constructor TfrmMain.Create(AOwner: TComponent);
var
  LService: IFMXApplicationEventService;
begin
  inherited;
  if TPlatformServices.Current.SupportsPlatformService(IFMXApplicationEventService, IInterface(LService)) then
    LService.SetApplicationEventHandler(AppEventHandler);
  LocationSensor1.Active := True;
end;

function TfrmMain.AppEventHandler(AAppEvent: TApplicationEvent; AContext: TObject): Boolean;
begin
  Result := True;
  case AAppEvent of
    TApplicationEvent.EnteredBackground:
    begin
      FIsInBackground := True;
      Memo1.Lines.Add('Entered background');
    end;
    TApplicationEvent.WillBecomeForeground:
    begin
      FIsInBackground := False;
      Memo1.Lines.Add('Becoming foreground');
    end
  else
    Result := False;
  end;
end;

procedure TfrmMain.LocationSensor1LocationChanged(Sender: TObject; const [Ref] OldLocation, NewLocation: TLocationCoord2D);
const
  cForegroundBackground: array[Boolean] of string = ('Foreground', 'Background');
var
  LTimestamp, LLocation: string;
begin
  LTimestamp := FormatDateTime('yyyy/mm/dd hh:nn:ss.zzz', Now);
  LLocation := Format('Lat: %.4f, Long: %.4f', [NewLocation.Latitude, NewLocation.Longitude]);
  Memo1.Lines.Add(Format('%s - %s - [%s]', [LTimestamp, LLocation, cForegroundBackground[FIsInBackground]]));
end;

end.
