unit FMain;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Rtti, System.Classes,
  System.Variants, FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs,
  FMX.StdCtrls, Data.Bind.EngExt, Fmx.Bind.DBEngExt, Fmx.Bind.Grid,
  System.Bindings.Outputs, Fmx.Bind.Editors, Data.Bind.Components, FMX.Layouts,
  Fmx.Bind.Navigator, FMX.Edit, Data.Bind.Grid, Data.Bind.DBScope, FMX.Grid,
  Data.DB, Datasnap.DBClient, Data.Bind.DBLinks, Fmx.Bind.DBLinks;

type
  TfrmMain = class(TForm)
    cdsBoolean: TClientDataSet;
    cdsBooleanName: TStringField;
    cdsBooleanIsActive: TBooleanField;
    cdsBooleanIsActiveInt: TIntegerField;
    grdBoolean: TStringGrid;
    BindSourceDB1: TBindSourceDB;
    BindingsList1: TBindingsList;
    edtName: TEdit;
    cbxIsActive: TCheckBox;
    cbxIsActiveInt: TCheckBox;
    BindNavigator1: TBindNavigator;
    LinkControlToField1: TLinkControlToField;
    LinkControlToField2: TLinkControlToField;
    LinkGridToDataSourceBindSourceDB1: TLinkGridToDataSource;
    LinkControlToField3: TLinkControlToField;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.fmx}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  cdsBoolean.LogChanges := False;
  cdsBoolean.Insert;
  cdsBooleanName.AsString := 'Text A';
  cdsBooleanIsActive.AsBoolean := True;
  cdsBooleanIsActiveInt.AsInteger := -1;
  cdsBoolean.Post;
  cdsBoolean.Insert;
  cdsBooleanName.AsString := 'Text B';
  cdsBooleanIsActive.AsBoolean := False;
  cdsBooleanIsActiveInt.AsInteger := 0;
  cdsBoolean.Post;
  cdsBoolean.Insert;
  cdsBooleanName.AsString := 'Text C';
  cdsBooleanIsActive.AsBoolean := True;
  cdsBooleanIsActiveInt.AsInteger := -1;
  cdsBoolean.Post;
end;

procedure RegisterOutputConversions;
begin
  TValueRefConverterFactory.UnRegisterConversion(TypeInfo(Boolean), TypeInfo(String));
  TValueRefConverterFactory.RegisterConversion(TypeInfo(Boolean), TypeInfo(String),
  TConverterDescription.Create(
    procedure(const I: TValue; var O: TValue)
    begin
      if I.AsBoolean then
        O := TValue.From<String>('-1')
      else
        O := TValue.From<String>('0');
    end,
    'BoolToString', 'BoolToString', EmptyStr, True, EmptyStr, nil)
  );
end;

procedure UnregisterOutputConversions;
begin
  TValueRefConverterFactory.UnRegisterConversion(TypeInfo(Boolean), TypeInfo(String));
end;

initialization
  RegisterOutputConversions;
finalization
  UnregisterOutputConversions;
end.
