unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  FMX.Layouts, FMX.Memo
  {$IFDEF ANDROID}
, Androidapi.NativeActivity,
  Posix.Pthread
{$ENDIF}
  ;


type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Layout1: TLayout;
    Memo2: TMemo;
    Memo3: TMemo;
    Splitter1: TSplitter;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  uParallel;

{$R *.fmx}

{$IFDEF ANDROID}
procedure MyEndThreadProc(ExitCode:Integer);
var
  PActivity: PANativeActivity;
begin
    PActivity := PANativeActivity(System.DelphiActivity);
    PActivity^.vm^.DetachCurrentThread(PActivity^.vm);
    pthread_exit(ExitCode);
end;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
var
SL, SL2, SL3: TStringList;
begin

SL := TStringList.Create;
SL2 := TStringList.Create;
SL3 := TStringList.Create;

SL.Text := Memo1.Lines.Text;

 ParallelFor(0, SL.Count - 1, procedure(I: Integer; ThreadID: Integer)
  begin
   case ThreadID of
    0,2,4,6,8,10,12,14,16,18,20,22: begin
     SL2.Append(inttostr(threadid) + ' ' + SL[I] + ' ' + inttostr(random(9999)) + ' ' + inttostr(random(9999)));
    end;
    1,3,5,7,9,11,13,15,17,19,21,23: begin
     SL3.Append(inttostr(threadid) + ' ' + SL[I] + ' ' + inttostr(random(9999)) + ' ' + inttostr(random(9999)));
    end;
   end;

  end);

Memo2.Lines.Text := SL2.Text;
Memo3.Lines.Text := SL3.Text;

SL3.Free;
SL2.Free;
SL.Free;


end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{$IFDEF ANDROID}
  EndThreadProc := MyEndThreadProc;
{$ENDIF}
end;

end.
