unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  System.Rtti, System.Bindings.Outputs, Fmx.Bind.Editors, Data.Bind.EngExt,
  Fmx.Bind.DBEngExt, FMX.StdCtrls, Data.Bind.Components, Data.Bind.DBScope,
  Data.DB, FireDAC.Comp.DataSet, FireDAC.Comp.Client, FMX.Controls.Presentation,
  FMX.Edit, FMX.TMSLiveGridDataBinding, Data.Bind.Grid, FMX.TMSBaseControl,
  FMX.TMSGridCell, FMX.TMSGridOptions, FMX.TMSGridData, FMX.TMSCustomGrid,
  FMX.TMSLiveGrid, FMX.TMSCustomEdit, FMX.TMSEdit, FMX.ScrollBox, FMX.Memo;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    FDMemTable1: TFDMemTable;
    BindSourceDB1: TBindSourceDB;
    BindingsList1: TBindingsList;
    Button1: TButton;
    TMSFMXLiveGrid1: TTMSFMXLiveGrid;
    Edit1: TTMSFMXEdit;
    Edit2: TTMSFMXEdit;
    Edit3: TTMSFMXEdit;
    Edit4: TTMSFMXEdit;
    LinkControlToField1: TLinkControlToField;
    LinkControlToField2: TLinkControlToField;
    LinkControlToField3: TLinkControlToField;
    LinkControlToField4: TLinkControlToField;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Memo1: TMemo;
    LinkGridToDataSourceBindSourceDB1: TLinkGridToDataSource;
    Label6: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Edit1ChangeTracking(Sender: TObject);
    procedure Edit2ChangeTracking(Sender: TObject);
    procedure Edit3ChangeTracking(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure Edit2KeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure Edit3KeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Calculate;
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

procedure DelayedSetFocus(Control: TControl);
begin
  TThread.CreateAnonymousThread(
    procedure
    begin
      TThread.Synchronize( nil,
         procedure
         begin
           Control.SetFocus;
         end
      );
    end
  ).Start;
end;


procedure TForm1.Calculate;
begin
  if FDMemTable1.State in [dsEdit, dsInsert] then
  FDMemTable1.Post;
end;

procedure TForm1.Edit1ChangeTracking(Sender: TObject);
begin
Calculate;
end;

procedure TForm1.Edit1KeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  if Key = vkReturn then begin
    DelayedSetFocus(Edit2);
  end;
end;

procedure TForm1.Edit2ChangeTracking(Sender: TObject);
begin
Calculate;
end;

procedure TForm1.Edit2KeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  if Key = vkReturn then begin
    DelayedSetFocus(Edit3);
  end;
end;

procedure TForm1.Edit3ChangeTracking(Sender: TObject);
begin
Calculate;
end;

procedure TForm1.Edit3KeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  if Key = vkReturn then begin
    DelayedSetFocus(Edit4);
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
TLinkObservers.ControlChanged(Edit4);
end;


end.

