unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.TabControl,
  FMX.Layouts, FMX.ListBox, FMX.StdCtrls;

type
  TForm1 = class(TForm)
    TabControl1: TTabControl;
    TabItem1: TTabItem;
    TabItem2: TTabItem;
    ListBox1: TListBox;
    ListBox2: TListBox;
    ToolBar1: TToolBar;
    SpeedButton1: TSpeedButton;
    ListBoxItem1: TListBoxItem;
    ListBoxItem2: TListBoxItem;
    ListBoxItem3: TListBoxItem;
    ListBoxItem4: TListBoxItem;
    ListBoxItem5: TListBoxItem;
    ListBoxItem6: TListBoxItem;
    ListBoxItem7: TListBoxItem;
    ListBoxItem8: TListBoxItem;
    ListBoxItem9: TListBoxItem;
    procedure ListBoxItemsClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

uses
  Androidapi.JNI.GraphicsContentViewText, FMX.Helpers.Android, Androidapi.Helpers;

procedure TForm1.ListBoxItemsClick(Sender: TObject);
var
  cursor: JCursor;
  catalog, SMSListBoxItem: TListBoxItem;
begin
  catalog := TListBoxItem(Sender);
  ListBox2.Clear;
  ListBox2.BeginUpdate;
  try
    cursor := SharedActivity.getContentResolver.query(
     StrToJURI(catalog.ItemData.Detail),
      nil,
       nil,
        nil,
         nil);

    if(cursor.getCount > 0) then
    begin

      while (cursor.moveToNext) do
      begin

        SMSListBoxItem := TListBoxItem.Create(ListBox2);

        SMSListBoxItem.ItemData.Text := JStringToString(cursor.getString(
        cursor.getColumnIndex(StringToJString('ADDRESS'))));

        ListBox2.AddObject(SMSListBoxItem);

      end;
    end;


  finally
    cursor.close;
    ListBox2.EndUpdate;
  end;

  TabControl1.ActiveTab := TabItem2;

end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  TabControl1.ActiveTab := TabItem1;
end;

end.
