unit Unit2;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.Ani, FBSprite,
  FMX.Layouts, FMX.Memo, FMX.Objects;

type
  TForm2 = class(TForm)
    Image1: TImage;
    Memo1: TMemo;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Memo2: TMemo;
    Memo3: TMemo;
    Memo4: TMemo;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Sprite1: TSprite;
    PathAnimation1: TPathAnimation;
  end;

var
  Form2: TForm2;

implementation

{$R *.fmx}

procedure TForm2.FormCreate(Sender: TObject);
var
s: TImage;
t: TMemo;
 i: integer;
begin
   for i := 0 to 3 do
    begin
    case i of
     0:  begin
         s:= Image1;
         t:= Memo1;
         end;
     1:  begin
         s:= Image2;
         t:= Memo2;
         end;
    2:  begin
         s:= Image3;
         t:= Memo3;
         end;
    3:  begin
         s:= Image4;
         t:= Memo4;
         end;
    end;
    Sprite1 := TSprite.Create(Self);
    Sprite1.Parent := Form2;
    Sprite1.Position.X := 10 + Random(200);
    Sprite1.Position.Y := 100 + Random(200);
    Sprite1.Width := 200;
    Sprite1.Height := 200;
    Sprite1.LoadSpriteSheet(s.Bitmap);
    Sprite1.LoadSpriteSheetTxt(t.Lines);
    Sprite1.FrameCount := 2;
    Sprite1.Loop := true;
    Sprite1.Interval := 200;
    Sprite1.SetFrameRange(0,2);
    Sprite1.Enabled := True;
    Sprite1.Visible := true;
    PathAnimation1 := TPathAnimation.Create(Self);
    PathAnimation1.Parent := Sprite1;
    PathAnimation1.Path.MoveTo(PointF(Random(100)*50, 10));
    PathAnimation1.Path.LineTo(PointF(Random(30)*100,Random(5)*10));
    PathAnimation1.Path.LineTo(PointF(form2.Width - 60,0));
    PathAnimation1.Path.LineTo(PointF(form2.Height -60,form2.Height -60));
    PathAnimation1.Path.ClosePath;
    PathAnimation1.Loop := True;
    PathAnimation1.Duration := 30;
    //PathAnimation1.Start;
    end;
end;
end.
