unit u_fmx_simple_firemonkey_object_inspector;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.Layouts, FMX.Memo,
  FMX.Objects, FMX.Edit, FMX.ListBox, FMX.StdCtrls, FMX.Controls.Presentation;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    Panel2: TPanel;
    exit_: TButton;
    clear_: TButton;
    Splitter1: TSplitter;
    xy_panel_: TPanel;
    property_selector_combobox_: TComboBox;
    VertScrollBox1: TVertScrollBox;
    property_panel_: TPanel;
    property_in_place_edit_: TEdit;
    debug_fill_: TButton;
    debug_clear_: TButton;
    procedure clear_Click(Sender: TObject);
    procedure exit_Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure property_in_place_edit_KeyDown(Sender: TObject; var Key: Word;
      var KeyChar: Char; Shift: TShiftState);
    procedure property_selector_combobox_Change(Sender: TObject);
    procedure debug_fill_Click(Sender: TObject);
    procedure debug_clear_Click(Sender: TObject);
  private
    procedure handle_property_value_mousedown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single);
  public
  end;

var
  Form1: TForm1;

implementation
  uses TypInfo
       , Rtti
       , u_display_xe2
       // , u_display_fmx_object
       ;

    {$R *.fmx}

    const k_property_value_x= 80+ 2;
          k_value_width= 100;
    var g_y: Single= 5;
        g_property_count: Integer= 0;

    procedure fill_property_selector_combobox;
      var l_component_index: Integer;
      begin
        with Form1 do
        begin
          property_selector_combobox_.Items.Clear;
          for l_component_index:= 0 to ComponentCount- 1 do
            property_selector_combobox_.Items.Add(Components[l_component_index].Name);
          property_selector_combobox_.ItemIndex:= 0;
        end; // with Form1, property_selector_listbox_
      end; // fill_property_selector_combobox

    procedure add_fmx_property(p_property_name, p_property_value: String);
      var l_c_property_name_label: tLabel;
          l_c_value_rectangle: tRectangle;
          l_c_property_value_text: tText;
          l_height: Single;
      begin
        with Form1 do
        begin
          l_height:= property_in_place_edit_.Height+ 2;

          l_c_property_name_label:= tLabel.Create(Form1);
          with l_c_property_name_label do
          begin
            Parent:= property_panel_;
            Position.X:= 5;
            Position.Y:= g_y+ 2;
            Text:= p_property_name;
            // -- debug
            Name:= Text+ '_name_label_'+ IntToStr(g_property_count);
          end; // with l_c_property_name_label

          l_c_value_rectangle:= tRectangle.Create(Form1);
          with l_c_value_rectangle do
          begin
            Parent:= property_panel_;
            Position.X:= k_property_value_x;
            Position.Y:= g_y;
            Width:= k_value_width;
            Stroke.Color:= TAlphaColorRec.Red;
            Height:= l_height;

            // -- debug
            Name:= l_c_property_name_label.Text+ '_value_rectangle_'+ IntToStr(g_property_count);
          end; // with l_c_value_rectangle

          l_c_property_value_text:= tText.Create(Form1);
          with l_c_property_value_text do
          begin
            Parent:= l_c_value_rectangle;
            Position.X:= 4;
            Position.Y:= 1;
            Width:= k_value_width;
            Height:= l_height- 2;
            HorzTextAlign:= TTextAlign.taLeading;
            Text:= p_property_value;

            // -- attach the label to the rTextcomponent
            // --   to be able to find the property name from the tText
            Tag:= NativeInt(l_c_property_name_label);

            // -- the font color
            Fill.Color:= TAlphaColorRec.DarkTurquoise;

            OnMouseDown:= handle_property_value_mousedown;
          end; // with l_c_property_value_text
        end; // with Form1

        g_y:= g_y+ l_height+ 2;
        Inc(g_property_count);
      end; // add_fmx_property

    procedure detach_in_place_edit;
      begin
        with Form1.property_in_place_edit_ do
        begin
          // -- The tEdit becomes invisible
          Parent:= Form1;
          Tag:= 0;
          Visible:= False;
        end; // with Form1.property_in_place_edit_
      end; // detach_in_place_edit

    procedure display_in_place_edit;
      var l_integer: NativeInt;
      begin
        if Form1.property_in_place_edit_= Nil
          then display('NIL')
          else display(Format('5.2f', [Form1.property_in_place_edit_.Width]));

        l_integer:= NativeInt(Form1.property_in_place_edit_.Parent);
        display('in_place_edit_.Parent $'+ IntToHex(l_integer, 4));
      end; // display_in_place_edit

    procedure clear_object_inspector;
      var l_child_index: Integer;
          l_c_fmx_object: tFmxObject;
      begin
        // -- do not remove if not yet filled
        if Form1.property_panel_.ChildrenCount= 1
          then Exit;

        display('> === clear');

        display_in_place_edit;

        // -- if had clicked a value, the in_place_edit had becomea CHILD of the tRectangle
        detach_in_place_edit;

        with Form1.property_panel_ do
        begin
          display('child_0_classname '+ Children[0].ClassName);
          l_child_index:= ChildrenCount- 1;
          while l_child_index>= 0 do
          begin
            l_c_fmx_object:= Children[l_child_index];
            display(Format('%3d ', [l_child_index])+ l_c_fmx_object.Name);
            if ((l_c_fmx_object is tLabel)
                or (l_c_fmx_object is tRectangle)) and (l_c_fmx_object.Name<> '')
              then begin
                  display('  erase '+ l_c_fmx_object.Name);
                  RemoveObject(l_c_fmx_object);
(*
                  if f_indexof_fmx_child_object(l_c_fmx_object, Form1.property_in_place_edit_)>= 0
                    then begin
                        display('in_place_is_child_of '+ l_c_fmx_object.Name);
                        display('in_place_owner '+ Form1.property_in_place_edit_.Owner.Name);
                  // l_c_fmx_object.Free
                      end
                    else
*)
                      FreeAndNil(l_c_fmx_object);
                end;

            Dec(l_child_index);
          end; // while l_child_index
        end; // with Form1.property_panel_

        display_in_place_edit;
        display('< === clear');
      end; // clear_object_inspector

    procedure fill_fmx_object_properties(p_c_component: tComponent);

      procedure get_properties_using_typinfo;
        var l_pt_property_list: PPropList;
            l_property_count : Integer;
            l_property_index : Integer;
            l_property_name, l_property_value: String;
        begin
          GetMem(l_pt_property_list, SizeOf(Pointer) * GetTypeData(p_c_component.ClassInfo)^.PropCount);

          try
            l_property_count := GetPropList(p_c_component.ClassInfo,tkProperties, l_pt_property_list,true);

            for l_property_index:= 0 to l_property_count- 1 do
            begin
              l_property_name:= GetPropName(l_pt_property_list^[l_property_index]);
              try
              l_property_value:= GetPropValue(p_c_component, l_property_name, True);
              except
              end;

              add_fmx_property(l_property_name, l_property_value);
            end; // for l_property_index
          finally
            FreeMem(l_pt_property_list);
          end;
        end; // get_properties_using_typinfo

      procedure get_properties_using_rtti;
        var l_rtti_context: tRttiContext;
            l_rtti_type: tRttiType;
            l_c_rtti_property: tRttiProperty;
            l_property_name, l_property_value: String;
        begin
(*
          l_rtti_context:= tRttiContext.Create;
*)
          l_rtti_type:= l_rtti_context.GetType(p_c_component.ClassType);
          for l_c_rtti_property in l_rtti_type.GetProperties do
          begin
            l_property_name:= l_c_rtti_property.Name;
            l_property_value:= 'aha';



(*
  TTypeKind = (tkUnknown,
    , tkSet, tkClass, tkMethod
    tkVariant, tkArray, tkRecord, tkInterface, tkInt64, tkDynArray, tkUString,
    tkClassRef, tkPointer, tkProcedure);
*)

            if l_c_rtti_property.PropertyType.TypeKind in
                [tkInteger, tkChar
                 , tkFloat
                 , tkString
                 , tkWChar, tkLString, tkWString
                 , tkEnumeration
                 ]
              then l_property_value:= l_c_rtti_property.GetValue(p_c_component).ToString
              else l_property_value:= '?';

            add_fmx_property(l_property_name, l_property_value);
          end;
        end; // get_properties_using_rtti

      begin // fill_fmx_object_properties
        g_y:= 2;
        get_properties_using_typinfo;
(*
        get_properties_using_rtti;
*)

        Form1.property_panel_.Height:= g_y;
      end; // fill_fmx_object_properties

    procedure fill_object_inspector(p_component_name: String);
      var l_c_component: tComponent;
      begin
        display('fill_with '+ p_component_name);
        l_c_component:= Form1.FindComponent(p_component_name);
        if l_c_component is tFmxObject
          then begin
              display('  '+ l_c_component.Name);

              fill_fmx_object_properties(tFmxObject(l_c_component));
            end;
      end; // fill_object_inspector

    // -- events

    procedure TForm1.FormCreate(Sender: TObject);
      begin
        initialize_display(Memo1.Lines);
        fill_property_selector_combobox;
      end; // FormCreate

    procedure TForm1.clear_Click(Sender: TObject);
      begin
        Memo1.Lines.Clear;
      end; // clear_Click

    procedure TForm1.exit_Click(Sender: TObject);
      begin
        Close;
      end; // exit_Click

    // -- oi

    procedure TForm1.property_in_place_edit_KeyDown(Sender: TObject; var Key: Word;
        var KeyChar: Char; Shift: TShiftState);
      var l_c_property_text: tText;
          l_selected_component_name: String;
          l_c_component: TComponent;
          l_c_property_name_label: tLabel;
      begin
        if Key= 13
          then begin
              display('in_place_enter');
              property_in_place_edit_.Visible:= False;
              l_c_property_text:= tText(property_in_place_edit_.Tag);
              l_c_property_text.Text:= property_in_place_edit_.Text;

              // -- update the true property
              with property_selector_combobox_ do
                l_selected_component_name:= Items[ItemIndex];
              l_c_property_name_label:= tLabel(l_c_property_text.Tag);

              l_c_component:= FindComponent(l_selected_component_name);
              setPropValue(l_c_component, l_c_property_name_label.Text, property_in_place_edit_.Text);

              // -- The tEdit becomes invisible
              detach_in_place_edit;
            end;
      end; // property_in_place_edit_KeyDown

    procedure TForm1.property_selector_combobox_Change(Sender: TObject);
      begin
        with property_selector_combobox_ do
        begin
          display(IntToStr(ItemIndex));
          if ItemIndex>= 0
            then begin
                clear_object_inspector;

                fill_object_inspector(Items[ItemIndex]);
              end;
        end; // with property_selector_combobox_
      end; // property_selector_combobox_Change

    procedure tForm1.handle_property_value_mousedown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Single);
      var l_c_sender_text: tText;
          l_c_property_value_rectangle: tRectangle;
      begin
        // display('down '+ (Sender as tLabel).Text);
        if not (Sender is tText)
          then display('*** not tText');

        l_c_sender_text:= Sender as tText;
        with l_c_sender_text, Position do
          display(Format('down %5.2f %5.2f', [X, Y])+ Text);

        l_c_property_value_rectangle:= l_c_sender_text.Parent as tRectangle;

        with l_c_property_value_rectangle, Position do
          display(Format('rect_parent %5.2f %5.2f ', [X, Y])+ Name);

        with Form1, property_in_place_edit_ do
        begin
          Parent:= l_c_property_value_rectangle;
          // -- position relative to the PARENT
          Position.X:= 4;
          Position.Y:= 1;

          // -- attach the tText to the in place edit Tag
          Tag:= NativeInt(l_c_sender_text);

          Text:= 'aha';
          Text:= l_c_sender_text.Text;
          Visible:= True;
          display('edit_parent '+ Parent.Name);
        end; // with Form1, property_in_place_edit_
      end; // handle_property_value_mousedown

    // -- debug fill / clear

    procedure TForm1.debug_fill_Click(Sender: TObject);
      begin
        with property_selector_combobox_ do
        begin
          display(IntToStr(ItemIndex));
          if ItemIndex>= 0
            then begin
                fill_object_inspector(Items[ItemIndex]);
              end;
        end; // with property_selector_combobox_
      end; // debug_fill_Click

   procedure TForm1.debug_clear_Click(Sender: TObject);
      begin
        clear_object_inspector;
      end; // debug_clear_Click

    end.
