unit u_display_xe2;
  interface
    uses System.SysUtils, System.Classes;

    var g_c_strings_ref: tStrings= Nil;
        g_do_display: Boolean= True;

    procedure initialize_display(p_c_strings: tStrings);

    function f_spaces(p_space_count: integer): String;
    procedure display(p_text: String);
    function f_display_TF(p_boolean: Boolean): String;

  implementation

    procedure initialize_display(p_c_strings: tStrings);
      begin
        g_c_strings_ref:= p_c_strings;
      end; // initialize_display

    function f_spaces(p_space_count: integer): String;
      begin
        Result:= Format('%'+ IntToStr(p_space_count)+'s', ['']);
      end; // f_spaces

    procedure display(p_text: String);
      begin
        if g_do_display
          then g_c_strings_ref.Add(p_text);
      end; // display

    function f_display_TF(p_boolean: Boolean): String;
      begin
        if p_boolean
          then Result:= 'T'
          else Result:= 'F';
      end; // display_TF

end.
